/* -*-C-*- prxbmap.h */
/*-->prxbmap*/
/**********************************************************************/
/****************************** prxbmap *******************************/
/**********************************************************************/

void
prxbmap()

{
    register UNSIGN32 *p;
    register INT16 i,j,k,ybottom,ytop;

    /* The Printronix encodes 6 horizontal bits in a single ASCII */
    /* character biased by 64 to make it printable, but requires that */
    /* the bits be reversed.  The following table is indexed by a */
    /* 6-bit pattern (0..63) and was produced automatically by an */
    /* EMACS TECO macro */
    /*  raster	   code as */
    /*  123456 -->  654321 */
    static int remap[] =
	{   /* 1000000 --> 1000000 */
	64,
	/* 1000001 --> 1100000 */  96,
	/* 1000010 --> 1010000 */  80,
	/* 1000011 --> 1110000 */  112,
	/* 1000100 --> 1001000 */  72,
	/* 1000101 --> 1101000 */  104,
	/* 1000110 --> 1011000 */  88,
	/* 1000111 --> 1111000 */  120,
	/* 1001000 --> 1000100 */  68,
	/* 1001001 --> 1100100 */  100,
	/* 1001010 --> 1010100 */  84,
	/* 1001011 --> 1110100 */  116,
	/* 1001100 --> 1001100 */  76,
	/* 1001101 --> 1101100 */  108,
	/* 1001110 --> 1011100 */  92,
	/* 1001111 --> 1111100 */  124,
	/* 1010000 --> 1000010 */  66,
	/* 1010001 --> 1100010 */  98,
	/* 1010010 --> 1010010 */  82,
	/* 1010011 --> 1110010 */  114,
	/* 1010100 --> 1001010 */  74,
	/* 1010101 --> 1101010 */  106,
	/* 1010110 --> 1011010 */  90,
	/* 1010111 --> 1111010 */  122,
	/* 1011000 --> 1000110 */  70,
	/* 1011001 --> 1100110 */  102,
	/* 1011010 --> 1010110 */  86,
	/* 1011011 --> 1110110 */  118,
	/* 1011100 --> 1001110 */  78,
	/* 1011101 --> 1101110 */  110,
	/* 1011110 --> 1011110 */  94,
	/* 1011111 --> 1111110 */  126,
	/* 1100000 --> 1000001 */  65,
	/* 1100001 --> 1100001 */  97,
	/* 1100010 --> 1010001 */  81,
	/* 1100011 --> 1110001 */  113,
	/* 1100100 --> 1001001 */  73,
	/* 1100101 --> 1101001 */  105,
	/* 1100110 --> 1011001 */  89,
	/* 1100111 --> 1111001 */  121,
	/* 1101000 --> 1000101 */  69,
	/* 1101001 --> 1100101 */  101,
	/* 1101010 --> 1010101 */  85,
	/* 1101011 --> 1110101 */  117,
	/* 1101100 --> 1001101 */  77,
	/* 1101101 --> 1101101 */  109,
	/* 1101110 --> 1011101 */  93,
	/* 1101111 --> 1111101 */  125,
	/* 1110000 --> 1000011 */  67,
	/* 1110001 --> 1100011 */  99,
	/* 1110010 --> 1010011 */  83,
	/* 1110011 --> 1110011 */  115,
	/* 1110100 --> 1001011 */  75,
	/* 1110101 --> 1101011 */  107,
	/* 1110110 --> 1011011 */  91,
	/* 1110111 --> 1111011 */  123,
	/* 1111000 --> 1000111 */  71,
	/* 1111001 --> 1100111 */  103,
	/* 1111010 --> 1010111 */  87,
	/* 1111011 --> 1110111 */  119,
	/* 1111100 --> 1001111 */  79,
	/* 1111101 --> 1101111 */  111,
	/* 1111110 --> 1011111 */  95,
	/* 1111111 --> 1111111 */  127
    };

    ytop = YBIT-1;

    k = -1;	    /* find bottom non-zero raster */
    for (j = 0; (j < ytop) && (k < 0); ++j) /* loop over raster lines */
    {
	p = BITMAP(j,XBIT-1);
	for (k = XBIT - 1; ((k >= 0) && (*p == 0)); --k)
	    --p;		/* trim white space */
    }
    ybottom = MAX(0,j-1);

    putchar('\f');	/* start new page with FF */
    for (j = (INT16)(topmargin*((float)YDPI)); j > 0; --j)
    {				/* supply top margin spacing */
	putchar('\005');	/* Printronix graphics prefix */
	NEWLINE(stdout);
    }
    for (j = ytop; (j >= ybottom) ; --j)    /* loop over raster lines */
    {
	p = BITMAP(j,XBIT-1);
	for (k = XBIT - 1; ((k >= 0) && (*p == 0)); --k)
	    --p;		/* trim white space */
	putchar('\005');	/* Printronix graphics prefix */

	for (i = (5 + (INT16)(leftmargin*((float)XDPI)))/6;
	    (i > 0) && (k >= 0); --i)
	    putchar('\100');/* left margin spacing if line not empty */

	p = BITMAP(j,0);	/* the j-th raster line */

	for (i = 0; i <= k; ++i)/* loop over trimmed raster */
	{ /* use machine-specific coding here for efficiency */
	    putchar(remap[((*p) >> 30) & 077]);
	    putchar(remap[((*p) >> 24) & 077]);
	    putchar(remap[((*p) >> 18) & 077]);
	    putchar(remap[((*p) >> 12) & 077]);
	    putchar(remap[((*p) >>  6) & 077]);
	    putchar(remap[((*p)      ) & 077]);
	    ++p;
	}
	NEWLINE(stdout);
    }
    (void)fflush(stdout);
}
