/* screenio.h - display functions
   $Id: screenio.h,v 0.2 1997/03/28 03:17:29 tjchol01 Exp $
   Authors: Andrew Trevorrow, Ian Dall, Geoffrey Tobin, Tomasz J. Cholewo
 */

#ifndef __SCREENIO_H__
#define __SCREENIO_H__

#include "dvgt.h"

/* 0 = success, 1 = error */
/* These terminal i/o routines are highly system-dependent and have been
   designed for DVItoVDU and its auxiliary modules.

   Notes:
   - InitScreenIO saves the current tty characteristics,
   then sets the mode to cbreak with no echo.
   Clients should therefore call RestoreTerminal before terminating.
   - WriteFlush or WriteLine must be called to explicitly update the terminal
   (e.g., just before a read) or to synchronize output with writes
   from other modules that don't use ScreenIO.
   - WriteString assumes the end of a string is the first blank (if not full),
   so clients need to replace calls like WriteString('xxx = ') with
   WriteString('xxx ='); WriteChar(' ').
 */

#define CR              '\n'	/* SYSDEP: char read upon hitting Return key */
#define CTRLC           '\0'	/* SYSDEP: interrupt, see unixio */
#define CTRLZ           '\001'	/* SYSDEP: suspend, see unixio */
/* SYSDEP: unixio puts CTRLC and CTRLZ into input buffer (along with CR)
   upon getting a ^C or ^Z interrupt.
   (It can't put chr(3) and chr(26) into buffer
   because tty will detect another interrupt and we'll loop forever!)
 */
#define NUL             '\0'
#define FF              '\f'
#define CAN             '\030'
#define ESC             '\033'
#define FS              '\034'
#define GS              '\035'
#define US              '\037'
#define XXX             256


extern int textlinewidth;	/* text characters (columns) per line */
extern int textcolumn;		/* column in current text line */

extern char TeXtoASCII[XXX];	/* TeX char to ASCII char */


extern void InitScreenIO ();
extern void ReadChar PARAMS ((char *ch));
extern void ReadString PARAMS ((char *s));
extern boolean BusyRead PARAMS ((char *ch));
extern void WriteInt PARAMS ((int i));
extern void WriteLine ();

#define WriteChar(X) putchar(X)
#define WriteString(X) fputs(X, stdout)
#define WriteFlush() fflush(stdout)

extern int MesgInt PARAMS ((int i));
extern void MesgLine ();

extern int MesgChar PARAMS ((int ch));
extern int MesgString PARAMS ((const char *s));
extern int MesgFlush ();

extern void RestoreTerminal ();

#endif /* __SCREENIO_H__ */

/* end screenio.h */
