/*
 * TEX Device Driver  ver 2.29
 *
 * prtctl.h : Definition for prtctl.cfg
 *
 */
#define	NO_NUM			0
#define	BINARY_LTOH		1
#define	BINARY_HTOL		2
#define	DECIMAL_3		3
#define	DECIMAL_4		4
#define	DECIMAL_5		5
#define	DECIMAL_V		6

#define	TOTAL_BYTE		0x80
#define	ISO_NUMBER		0x40
#define	DIVIDE_ALL		0x30
#define	MULT_CONST		0x08

#define	TOP_IS_LOW		0x80
#define	TOP_IS_HIGH		0x00
#define	LEFT_IS_LOW		0xc0
#define	LEFT_IS_HIGH	0x40

#define	TYPE_BIT		0xc0
#define	FLAG_LBP		0x40

#define	NON_MOVING		0x20
#define	HEX_MODE		0x10

#define	LINK_BLOCK		0x80

#ifdef	LIPS3
#  ifdef ESCPAGE
#define	TMP_PRINTER		6
#  else
#define	TMP_PRINTER		5
#  endif
#else
#  ifdef ESCPAGE
#define	TMP_PRINTER		5
#  else
#define	TMP_PRINTER		4
#  endif
#endif

#ifdef	FAX
#define	MAX_PRINTER	(TMP_PRINTER+1)
#else
#define	MAX_PRINTER	TMP_PRINTER
#endif

#define	prt_ctr_file	"prtctl.cfg"

/*
 *	Format for a printer control with sending a number
 *
 *  len, link, pos, type, data .....		4+len bytes
 *
 *  len:  the length of data to be sent to printer
 *  link: link to next block (test LINK_BLOCK)
 *  pos:  the begining position of the data of number (top means 0)
 *	type: NO_NUM or BYNARY_LTOH or BYNARY_HTOL or DECIMAL_3 etc.
 *  data: the control sequence to be sent, its length equals len
 *		  some parts are replaced by the number formated according to type
 */

 /*
  * 	Data format file	(See prtctl.asm)
  *
  *  x, x, x, x, x, x, x, x, x, x, x, x, x, x, x, x   : 16 bytes device name
  *  'Q'
  *  0xff, ad_dot_cr, ?, ?, ?
  *  HW_MIN, HW_MAX
  *  ...
  *  dot_cr, brm_cr, dotg, dots, line_feed, form_feed, after_dot
  *  ...
  */

 /*
   *	HW_MIN ́APs󎚂ƂAHW_MIN ̃oCgEƂɂ݂āA
   *	ubNic VERT_BYTES*8A HW_MIN*8 hbgjɋ󔒂΁A
   *    ړ̃R[h𑗂BAAȍ~s܂ŋ󔒂ȂAȂɂ
   *	ȂBiP[hj
   *
   *	HW_MAXÄړArbgC[W𑗂Ƃ́ÃoCgP
   *    ł̍őlBȂ킿AHW_MAX*8 hbg̉BiP[hj
   *
   *	VERT_BYTES ͂Ps󎚂ۂ̏c̃hbg^WiPoCgj
   *	āCQSsv^̎́ARƂȂ
   *
   *    ad_dot_cr ́AePoCgŁA擪 dot_cr ̈ʒu\
   *
   *    dot_cr ŏłKvBȍ~AԖ
   *	dot_cr, brm_cr,... ȂĂ͂ȂB
   *
   *
   *		The followings are as in the above (with 4 bytes header)
   *
   * dot_cr:	rbgC[Ẅ󎚂ֈڂׂ̏BAs̒
   * nrm_cr:	ŕς́AAsɖ߂B
   * dotg  :	rbgC[Ẅ󎚂̃Rg[ĩhbgj
   * dots  :	hbgPʂŉEɈړiړj
   *			dots  len  0 ́Â悤ȃRg[oȂƂ
   *			ӖB
   * line_feed: 󎚉sR[h
   * form_feed: 󎚉y[WR[h
   * after_bit: rbg[C[W̃ubNf[^𑗂̃Rg[R[h
   * bit_row_header: header codes preceding every row of bits
   */
