dnl
dnl AC_ARG_WITHX, AC_ARG_WITHOUTX, AC_ARG_ENABLEX, AC_ARG_DISABLEX
dnl
dnl These macros behave just as AC_ARG_WITH and AC_ARG_ENABLE, except
dnl that they make sure the --help descriptions will be aligned properly
dnl
AC_DEFUN(AC_ARG_WITHX,
[AC_ARG_WITH([$1], 
  ifelse(builtin(eval, len([$1$5])<17),1,
    builtin(format, [[  --with-]%-17s%s], [$1$5], [$2]),
    [  --with-$1$5
                          $2]), [$3], [$4])])
AC_DEFUN(AC_ARG_WITHOUTX,
[AC_ARG_WITH([$1],
  ifelse(builtin(eval, len([$1$5])<14),1,
    builtin(format, [  [--without-]%-14s%s], [$1$5], [$2]),
    [  --without-$1$5
                          $2]), [$3], [$4])])
AC_DEFUN(AC_ARG_ENABLEX,
[AC_ARG_ENABLE([$1], 
  ifelse(builtin(eval, len([$1$5])<15),1,
    builtin(format, [  [--enable-]%-15s%s], [$1$5], [$2]),
    [  --enable-$1$5
                          $2]), [$3], [$4])])
AC_DEFUN(AC_ARG_DISABLEX,
[AC_ARG_ENABLE([$1],
  ifelse(builtin(eval, len([$1$5])<14),1,
    builtin(format, [  [--disable-]%-14s%s], [$1$5], [$2]),
    [  --disable-$1$5
                          $2]), [$3], [$4])])
dnl
dnl AC_ARG_WITH_BOOL(name, default, description)
dnl
AC_DEFUN(AC_ARG_WITH_BOOL, [
  define([VAR],[with_]translit($1,-,_))
  ifelse([$2], [yes],
    [AC_ARG_WITHOUTX([$1], [$3],
      [case "$withval" in
        yes|no) ;;
        *) VAR=yes ;;
      esac], VAR=yes)],
    [AC_ARG_WITHX([$1], [$3],
      [case "$withval" in
        yes|no) ;;
        *) VAR=no ;;
      esac], VAR=no)]dnl
  )
  undefine([VAR])
])
AC_DEFUN(AC_ARG_ENABLE_BOOL, [
  define([VAR],[enable_]translit($1,-,_))
  ifelse([$2], [yes],
    [AC_ARG_DISABLEX([$1], [$3],
      [case "$enableval" in
        yes|no) ;;
        *) VAR=yes ;;
      esac], VAR=yes)],
    [AC_ARG_ENABLEX([$1], [$3],
      [case "$enableval" in
        yes|no) ;;
        *) VAR=no ;;
      esac], VAR=no)]dnl
  )
  undefine([VAR])
])
