#This file belongs to the TOIL package : Ten plik nale/zy do pakietu TOIL
#This package is public domain         : Pakiet stanowi dobro powszechne
#For more info see `0TOILENG.LIC'      : Wi/ecej informacji w ,,0TOILPOL.LIC''
#============================================================================
#  AUXILIARY TASK FILE: extracts relevant information from the MF LOG-file
# ==========================================================================
BEGIN {
  fix_const(); get_tmp_config(TMP_CFG)
# GET AND CHECK THE FIRST LINE OF THE METAFONT LOG FILE
  getline 
  if (!/^This is (METAFONT|MetaPost)/)
    mess("Are you sure that", FILENAME, "is a METAFONT/MetaPost log file?")
}

/^:ENC:/ {was_ENC=1; print substr($0,6) > TMP_ENC}
/^:MAP:/ {was_MAP=1; map_line=map_line (map_line!="" ? " " : "") substr($0,6)}

END {
  if (was_MAP) {
    print map_line >> TMP_MAP
    if (CV["MAP"]=="") xmess=" newly created"
    mess("Font info appended to" xmess,
         sys_conc(CV["RES_MAP_DIR"], CV["USER_MAP"]))
  }
  if (was_ENC) mess("Encoding extracted to",
    sys_conc(CV["RES_ENC_DIR"], CV["ENC_NAME"] CV["RES_ENC_EXT"]))
  mess("Font metrics moved to", sys_conc(CV["RES_TFM_DIR"], CV["MF"] ".tfm"))
  if ((!CV["QUIET"]) && (LOG!="")) print "Transcript written on " LOG > "CON"
}

# ==========================================================================

function mess(s1,s2,s3,s4, s) {# at most four parts may occur
  s=s1; if (s2!="") s=s " " s2; if (s3!="") s=s " " s3; if (s4!="") s=s " " s4
  if (length(s)<=max_line) {
    if (!CV["QUIET"]) print s > "CON"; if (LOG!="") print s > LOG
  } else {
    if ((!CV["QUIET"]) && (s1!="")) print s1 > "CON"
    if ((LOG!="") && (s1!="")) print s1 > LOG
    if ((!CV["QUIET"]) && (s2!="")) print s2 > "CON"
    if ((LOG!="") && (s2!="")) print s2 > LOG
    if ((!CV["QUIET"]) && (s3!="")) print s3 > "CON"
    if ((LOG!="") && (s3!="")) print s3 > LOG
    if ((!CV["QUIET"]) && (s4!="")) print s4 > "CON"
    if ((LOG!="") && (s4!="")) print s4 > LOG
  }
}

function sys_conc(a, b) {# a -- directory, b -- file name
  if ((a=="") || (b ~ /:/)) return b
  else if (b=="") return a
  else return sys_name(a (a ~ /:$/ ? "" : "/" ) b)
}
function sys_name(n) {gsub(/\\+/,"/",n); gsub(/\/+/,"\\",n); return n}

function get_tmp_cfg_item(item_name, item) {
  CV[$1]=$0; gsub("^" $1 " +", "", CV[$1]); 
}

function get_tmp_config (TMP_CFG, v) {
  while (getline < TMP_CFG > 0) get_tmp_cfg_item()
#  for (v in CV) printf("%20s %s\n", v, CV[v])
  TMP_TMP=CV["TMP_TMP"]
  TMP_ENC=CV["TMP_ENC"]
  TMP_MAP=CV["TMP_MAP"]
}

function fix_const() {
# GENERAL CONSTANTS (used also in toila.awk and toilb.awk)
  QQ="\""
  max_line=79      # screen limit
  max_sys_line=127 # MSDOS limit
  TMP_CFG="~t~m~p~.cfg"
}

