#!/usr/bin/perl -i.bak

use English;

use vars qw(@MATH_MODE_SYMBOLS $MATH_MODE_SYMBOL_FILEPATH);

$MATH_MODE_SYMBOL_FILEPATH = $ARGV[1].'/math_mode_symbol_list.txt';



## get input
undef $INPUT_RECORD_SEPARATOR;
$file = <>;

#print STDERR "*****here's what i got ******\n$file\n";

## transform it

loadMathModeSymbols();

@MATH_MODE_BINARY_SYMBOLS = map(quotemeta,@MATH_MODE_BINARY_SYMBOLS);
my $symbol_list = join('|',@MATH_MODE_BINARY_SYMBOLS);

$beginMathModeRE = '(?:\\\\begin{(?:equation|align|eqnarray)\\*?}|\\$)';
$endMathModeRE = '(?:\\\\end{(?:equation|align|eqnarray)\\*?}|\\$)';
$beginMathModeWithCaptureRE = '(?:\\\\begin{((?:equation|align|eqnarray)\\*?)})';
#$beginMathModeWithCaptureRE = '(?:\\\\begin{((?:eq\\$)';
#$endMathModeWithCaptureRE = '(?:\\\\end{((?:equation|align|eqnarray)\\*?)}|\\$)';
$endMathModeWithCaptureRE = '(?:\\\\end{((?:equation|align|eqnarray)\\*?)}|\\$)';

$file =~ s/\$\$//g;


$file =~ s/(?<!\w)(\w (?:$symbol_list))(\s+$beginMathModeRE)/\$$1\$$2/gs;

$file =~ s/($endMathModeRE\s+)((?:$symbol_list) \w)(?!\w)/$1\$$2\$/gs;

#$file =~ s/$endMathModeWithCaptureRE(\s+)\\begin{\1}/oneNewlineOrNothing($2)/esg;

$file =~ s/\$(\s+)\$/oneNewlineOrNothing($1)/esg;


while ($file =~ s/\$([^\$]+)\$(\s*)$beginMathModeWithCaptureRE\s*/"\\begin{$3}".$1.oneNewlineOrNothing($2).' '/esg) 
{
#    print STDERR "FOUND: $1, $2, $3\n\n\n";
}

# print output
print $file; 
#print STDERR "Here's what I put: $file\n";


sub oneNewlineOrNothing {
    my ($expr) = @_;

    my $count = 0;
    my $i;
    my $whitespace = '';

    while ($expr =~ /\n/sg) {$count++;}

    if ($expr =~ /\s/) {$whitespace = ' '};

    if ($count == 0) {$expr = '';}
    else {
	$expr = "\n";
	for ($i = 0; $i < ($count - 1); $i++) {
	    $expr .= '\\\\ ';
	}
    }

    $expr = $whitespace . $expr; 
    

#    print STDERR "*** count = $count; expr: $expr ***\n";

    return $expr;
}


######################
# utility subroutines
######################


sub loadMathModeSymbols {

#I got the symbol tables by doing this on my own machine:
#    cd /usr/share/texmf/tex/latex
#    grep -r DeclareMathSymbol * > /tmp/t
#    perl -pi -e 's/.*?:\s*\\DeclareMathSymbol{?(\\\w+)}?(\s|{).*/$1/g' /tmp/t
#    perl -pi -e 's/.*?:\s*(\\\w+)(\s|$)/$1/gm' /tmp/t
#    perl -i -e 'while (<>) {if (!/:/) {print $_;}}' /tmp/t
#
#    cd {src directory of "The not so Short Introduction to LaTeX"}
#    cat lssym.tex | perl -e 'undef $/; $_ = <>; while (/(?:{(\\\w+)}|\\verb\|(\\\w+)\|)/g) {print "$1$2\n";}' lssym.tex  >> /tmp/t
#
#    sort /tmp/t > /tmp/t2
#    uniq /tmp/t2 > /tmp/t
#    grep -v '\\DeclareMathSymbol' /tmp/t > /tmp/t2 
#
#and then I moved /tmp/t2 into the file math_mode_symbol_list.txt


    $INPUT_RECORD_SEPARATOR = "\n";

    open(SYMBOLFILE, $MATH_MODE_SYMBOL_FILEPATH) or die "Can't open list of math mode symbols at $MATH_MODE_SYMBOL_FILEPATH";
    while ($line = <SYMBOLFILE>)
    {
	chomp $line;
	push(@MATH_MODE_SYMBOLS,$line);
	push(@MATH_MODE_BINARY_SYMBOLS,$line);
    }
    close(SYMBOLFILE);

	push(@MATH_MODE_BINARY_SYMBOLS,'+');
	push(@MATH_MODE_BINARY_SYMBOLS,'-');
	push(@MATH_MODE_BINARY_SYMBOLS,'*');
	push(@MATH_MODE_BINARY_SYMBOLS,'/');
	push(@MATH_MODE_BINARY_SYMBOLS,'=');

}



