/*  Main program for ETTOTEX in C
    K&R C

    6 Jan 92 JCC  \perp needs space after it.
    9 Apr 91 JCC  Single file, convert to K&R C (so it works on anything).
                  %d not %i formats
    4 Apr 91 JCC  Ignore end-of-file character. Convert char constants
                  to K&R (i.e., \000 not \x0).
   29 Mar 91 JCC  Remove CRs on input -- to work with UNIX.
   27 Mar 91 JCC  Handle several adjacent mathcodes.
   23 Mar 91 JCC  Get it working
   10 Mar 91 JCC  Start
*/

#include <stdio.h>
#include <string.h>


#define SIGNON       "ET to TeX converter, C version 1.02.  JCC  4 Apr 91\n"
#define MAXFILENAME  100

#define UNDEF        "\\undef" /* String for undefined Greek */

#define FALSE 0
#define TRUE  1
#define CR    13

/* ========== TYPES: ========= */
typedef char       *transtring;
typedef transtring greektran[256];

/* ==== GLOBAL VARIABLES: ======= */
greektran greektable;


/* ET characters: */

#define   symbol    7
#define   bksp      8

#define   beginsub  1
#define   endsub    2
#define   beginsup  3
#define   endsup    4
#define   beginmath 5
#define   endmath   6
#define   begineq   14
#define   endeq     15
#define   beginarg  16
#define   endarg    17
#define   frac      18
#define   beginfrac 18
#define   endfrac   19
#define   beginlog  20
#define   endlog    21
#define   beginmac  22
#define   endmac    23


/* TeX characters: */

#define   TeXActiveCh  '\\'
#define   CommentChar  '%'
#define   ArgChar      '#'
#define   BeginGroup   '{'
#define   EndGroup     '}'

/* Translation table: */

char translate[] = "\
a\\alpha \000\
b\\beta \000\
c\\psi \000\
d\\delta \000\
e\\epsilon \000\
f\\phi \000\
g\\gamma \000\
h\\eta \000\
i\\iota \000\
j\\dagger \000\
k\\kappa \000\
l\\lambda \000\
m\\mu \000\
n\\nu \000\
o\\omega \000\
p\\pi \000\
q\\chi \000\
r\\rho \000\
s\\sigma \000\
t\\tau \000\
u\\upsilon \000\
v\\theta \000\
w\\omega \000\
x\\xi \000\
y\\undef{y}\000\
z\\zeta \000\
A\\undef{A}\000\
B\\undef{B}\000\
C\\Psi \000\
D\\Delta \000\
F\\Phi \000\
G\\Gamma \000\
H\\undef{H}\000\
I\\undef{I}\000\
J\\partial \000\
K\\undef{K}\000\
L\\Lambda \000\
M\\undef{M}\000\
N\\int \000\
O\\Omega \000\
P\\prod \000\
Q\\Chi \000\
R\\Rho \000\
S\\sum \000\
T\\perp \000\
U\\Upsilon \000\
V\\Theta \000\
W\\undef{W}\000\
X\\Xi \000\
Y\\undef{Y}\000\
Z\\undef{Z}\000\
!\\hbar \000\
@\\circ \000\
#\\dalem \000\
$\\pound \000\
%\\equiv \000\
^\\infty \000\
&\\Pomeron \000\
*\\times \000\
(\\langle \000\
)\\rangle \000\
_\\propto \000\
+\\pm \000\
-\\mp \000\
=\\approx \000\
`\\ell \000\
[\\gets \000\
]\\to \000\
{\\gets \000\
}\\to \000\
;\\undef{;} \000\
\"\\sqrt \000\
'\\Reggeon \000\
|\\undef{|} \000\
,\\nabla \000\
.\\cdot \000\
/\\div \000\
<\\leq \000\
>\\geq \000\
\000 \
EXPANSION ROOM, FOR CONFIGURATION                             ";

int peekchar (source)
FILE *source;
{
   return (ungetc( getc(source), source));
}

void fixmath (source, dest)
FILE *source, *dest;
{
   /* If next character is math toggle etc, insert space */
   if (ismath(peekchar(source))) putc (' ', dest);
}

int isETmath (c)
char c;
{
   return ((c==beginmath) || (c==endmath) || (c==begineq) || (c==endeq));
}

int ismath (c)
char c;
{
   return (isETmath(c) || (c=='$'));
}

void init ()
{ int c;
  char *p;

  for (c=0; c<=255; c++) greektable[c] = NULL;
  p = translate;
  while (*p) {
     c = (*p) %256;
     p++;
     greektable[c] = p;
     p += strlen (p) + 1;   /* Allow for null at end. */
  }
}

int exist (filename)
char* filename;
{ FILE* stream;
  stream = fopen (filename, "r");
  if (stream != NULL) {
     fclose (stream);
     return (TRUE);
  } else {
     return (FALSE);
  }
}

int process_et_file (sourcename, destname)
char *sourcename, *destname;
{  FILE *source, *dest;
   int c;
   int numlines;

   numlines = 0;
   source = fopen (sourcename, "r");
   dest   = fopen (destname, "w");
   while ((c = getc(source)) != EOF) {
      switch (c) {
         case symbol:    if (!feof (source)) {
                           c = getc(source) % 256;
                           if (greektable[c])
                              fputs (greektable[c], dest);
                           else fprintf (dest, "%s{%d}", UNDEF, c);
                         };
                         break;
         case bksp:      fputs ("\\llap ", dest); break;

         case beginsub:  fputs ("_{", dest); break;
         case endsub:    fputs ("}", dest); break;
         case beginsup:  fputs ("^{", dest); break;
         case endsup:    fputs ("}", dest); break;
                         /* In following prevent trouble if an ET begin
                            or end math or eq is followed by another math
                            begin or end; translation of begin or end math
                            to single $ changes meaning when immediately
                            followed by another $ in translation: */
         case beginmath: fputs ("$", dest); fixmath(source, dest); break;
         case endmath:   fputs ("$", dest); fixmath(source, dest); break;
         case begineq:   fputs ("$$", dest); fixmath(source, dest); break;
         case endeq:     fputs ("$$", dest); fixmath(source, dest); break;
         case beginarg:  fputs ("{", dest); break;
         case endarg:    fputs ("}", dest); break;
         case beginfrac: fputs ("\\frac ", dest); break;
         case endfrac:   break;

         case beginlog:  fputs ("\\beginlog ", dest); break;
         case endlog:    fputs ("\\endlog ", dest); break;
         case beginmac:  fputs ("\\beginmac ", dest); break;
         case endmac:    fputs ("\\endmac ", dest); break;

         case CR: break; /* ignore carriage return (for UNIX!) */

         case TeXActiveCh:
         case CommentChar:
         default: putc (c, dest);
            if (c == '$') {
              /* Prevent trouble if TeX math toggle is followed by
                 ET begin or end math or equation: */
              if (isETmath (peekchar(source))) putc (' ', dest);
            } else if (c == '\n') {
               numlines++;
               if (numlines % 50 == 0)
                  fprintf (stderr, "[%d]%c", numlines, CR);
            }
      }
   }
   fclose (source);
   fclose (dest);
   printf ("%d lines processed\n", numlines);
   return (0);
}


int main (argc, argv)
int argc;
char *argv[];
{  char sourcename[MAXFILENAME+1], destname[MAXFILENAME+1];
      /* Leave space for the null! */

   printf (SIGNON);
   if (argc < 2)
      {
      puts ("Usage:  ettotexc file");
      puts (" converts file.et to file.tex.");
      return (1);
      }

   init();
   strncpy (sourcename, argv[1], MAXFILENAME-4);
   strncpy (destname, argv[1], MAXFILENAME-4);
   strcat  (sourcename, ".et");
   strcat  (destname, ".tex");
   if (!exist (sourcename)) {
      printf ("%s%s%s", "Source file ", sourcename, " does not exist.\n");
      return (2);
   }
   return (process_et_file (sourcename, destname));
}

