/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet;

import java.io.IOException;
import org.mariadb.jdbc.internal.common.packet.EOFPacket;
import org.mariadb.jdbc.internal.common.packet.ErrorPacket;
import org.mariadb.jdbc.internal.common.packet.LocalInfilePacket;
import org.mariadb.jdbc.internal.common.packet.OKPacket;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacket;
import org.mariadb.jdbc.internal.common.packet.ResultSetPacket;

public class ResultPacketFactory {
    private static final byte ERROR = -1;
    private static final byte OK = 0;
    private static final byte EOF = -2;
    private static final byte LOCALINFILE = -5;

    private ResultPacketFactory() {
    }

    public static ResultPacket createResultPacket(RawPacket rawPacket) throws IOException {
        byte b = rawPacket.getByteBuffer().get(0);
        switch (b) {
            case -1: {
                return new ErrorPacket(rawPacket);
            }
            case 0: {
                return new OKPacket(rawPacket);
            }
            case -2: {
                return new EOFPacket(rawPacket);
            }
            case -5: {
                return new LocalInfilePacket(rawPacket);
            }
        }
        return new ResultSetPacket(rawPacket);
    }
}

