/* CHESS FUNCTION(S): boxdraw(arg)
/*              DATE: 04/20/95
/*            AUTHOR: H. Dudler
/*
/*       DESCRIPTION: This function puts the appropriate box character
/* at the current location, taking into account the 4 neighboring box
/* characters (if any). Recognized arguments are: 'l','L','r','R','u',
/* 'U','d','D'. The argument indicates the drawing direction with a
/* LC character for single-line boxes and an UC character for double-
/* line boxes.
/* ---------------------------------------------------------------------

boxdraw
char arg; /* indicates drawing direction, single/double line
{
   char ch;
   char dir;
   char tmp[1];
   char nc[4];
   int lin;
   int col;
   int ix;
   int iy;
   /* 'bxsc': box-symbol (ASCII 179-218) bond-code table (see below):
   /* bond-code example (binary) for  :  01011000 = 88 decimal
   /*                single bond left  ٳ
   /*                single bond right ٳ
   /*                double bond up    ٳ
   /*                    no bond down  
   /* To stay away from cntl chars. 32 is added to bond code.
   /* For  (ASCII 208) 88+32=120=x is in location 208-179=29 of 'bxsc'

   char bxsc[40]; /* box-symbol code table
   strcpy(bxsc,"%ejb*ha4tq5puE:HBJxr8DA2zd1");

   /* 'dir': direction code:
   /*              4 possibilities: 0100,1000,0001,0010 (binary)
   /*          single horizontal            
   /*          double horizontal         
   /*          single vertical      
   /*          double vertical   

   dir=1;
   if(arg < 91) {  /* arg UC ?
     dir=2;
     arg=arg+32;   /* make arg LC
   }
   if((arg == 114) || (arg == 108))
     dir=4*dir     /* correct 'dir' if horizontal ('l' or 'r')

   lin=ask("file_line");   /* get curr. line and column no.
   col=ask("file_column");

   /* now look at neighbors (l,r,u,d):
   /* save bond codes in nc[] : [0],[1],[2],[3] = r,u,l,d

   {                  /* bond code from left neighbor
     nc[2]=dir/4; /* if draw direction is 'l', left code is given
     if(arg != 108) { /* not left, find nbr.code
       ch=' ';
       iy=0;
       if(col > 1) {
         get_text(lin,col-1,tmp,1);  /* left neighbor -> tmp[0]
         if(tmp[0] > 32)
           ch=tmp[0];
       }
       if((ch > 178) && (ch < 219)) {  /* nbr.is box char.
         ix=bxsc[ch-179]-32;           /* bond code of nbr.
         iy=ix/16;
         iy=iy%4;        /* bond extending towards current char.
       }
       nc[2]=iy;
     }
   }
   {                  /* bond code from right nbr.
     nc[0]=dir/4;
     if(arg != 114) {
       ch=' ';        /* details see left nbr.
       iy=0;
       get_text(lin,col+1,tmp,1);
       if(tmp[0] > 32)
         ch=tmp[0];
       if((ch > 178) && (ch < 219)) {
         ix=bxsc[ch-179]-32;
         iy=ix/64;
       }
       nc[0]=iy;
     }
   }
   {                  /* bond code from up nbr.
     nc[1]=dir;
     if(arg != 117) {
       ch=' ';          /* details see left nbr.
       iy=0;
       get_text(lin-1,col,tmp,1);
       if(tmp[0] > 32)
         ch=tmp[0];
       if((ch > 178) && (ch < 219)) {
         ix=bxsc[ch-179]-32;
         iy=ix%4;
       }
       nc[1]=iy;
     }
   }
   {                  /* bond code from down nbr.
     nc[3]=dir;
     if(arg != 100) {
       ch=' ';          /* details see left nbr.
       iy=0;
       get_text(lin+1,col,tmp,1);
       if(tmp[0] > 32)
         ch=tmp[0];
       if((ch > 178) && (ch < 219)) {
         ix=bxsc[ch-179]-32;
         iy=ix/4;
         iy=iy%4;
       }
       nc[3]=iy;
     }
   }

   /* neighbor survey done, construct proper box char.

   if((nc[0]+nc[2]) == 3) { /* unequal hor.bonds, no box chars.exist,
     nc[0]=0;               /* assume no bonds
     nc[2]=0;
   }
   if((nc[1]+nc[3]) == 3) { /* unequal vert.bonds, same
     nc[1]=0;
     nc[3]=0;
   }
   if(arg == 108) { /* left, find bond code
     nc[2]=dir/4;
     if((nc[0]+nc[1]+nc[3]) == 0) /* only 1 non-zero bond
       nc[0]=nc[2];               /* make opposite equal
   }
   else if(arg == 114) {  /* right, same
     nc[0]=dir/4;
     if((nc[1]+nc[2]+nc[3]) == 0) {
       nc[2]=nc[0];
     }
   }
   else if(arg == 117) { /* up, same
     nc[1]=dir;
     if((nc[0]+nc[2]+nc[3]) == 0)
       nc[3]=nc[1];
   }
   else if(arg == 100) { /* down, same
     nc[3]=dir;
     if((nc[0]+nc[1]+nc[2]) == 0)
       nc[1]=nc[3];
   }
   ch=nc[2]*64+nc[0]*16+nc[1]*4+nc[3]+32; /* bond code for new char.
   ix=strndx(bxsc,ch); /* find in code table
   tmp[0]=179+ix;
   tmp[1]=0;
   put_text_curr(0,tmp); /* put in place
   update_display;

   /* move cursor according to draw direction
   if(arg == 108)
     Cursor_left();
   else if(arg == 114)
     Cursor_right();
   else if(arg == 117)
     Cursor_up();
   else if(arg == 100)
     Cursor_down;
}
