/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.templates.ProjectTemplateManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ProjectTemplatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List templateList;

    public ProjectTemplatesPreferencePage() {
        this.setPreferenceStore(TexlipsePlugin.getDefault().getPreferenceStore());
        this.setDescription(TexlipsePlugin.getResourceString("preferenceProjectTemplatePageDescription"));
    }

    protected Control createContents(Composite parent) {
        Composite field = new Composite(parent, 0);
        GridData fgd = new GridData(1808);
        fgd.horizontalSpan = 3;
        field.setLayoutData((Object)fgd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        field.setLayout((Layout)gl);
        Label label = new Label(field, 16384);
        label.setText(TexlipsePlugin.getResourceString("preferenceProjectTemplateLabel"));
        label.setLayoutData((Object)new GridData());
        Label empty = new Label(field, 16384);
        empty.setLayoutData((Object)new GridData());
        this.templateList = new List(field, 2820);
        this.templateList.setItems(ProjectTemplateManager.loadUserTemplateNames());
        this.templateList.setLayoutData((Object)new GridData(1808));
        Composite column = new Composite(field, 0);
        column.setLayoutData((Object)new GridData(1808));
        column.setLayout((Layout)new GridLayout());
        Button remove = new Button(column, 8);
        remove.setText(TexlipsePlugin.getResourceString("preferenceProjectTemplateRemoveButton"));
        remove.setLayoutData((Object)new GridData());
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean reallyDelete;
                int s = ProjectTemplatesPreferencePage.this.templateList.getSelectionIndex();
                if (s >= 0 && (reallyDelete = MessageDialog.openConfirm((Shell)new Shell(), (String)TexlipsePlugin.getResourceString("preferenceProjectTemplateConfirmTitle"), (String)TexlipsePlugin.getResourceString("preferenceProjectTemplateConfirmDelete").replaceAll("%s", ProjectTemplatesPreferencePage.this.templateList.getItem(s))))) {
                    String item = ProjectTemplatesPreferencePage.this.templateList.getItem(s);
                    ProjectTemplateManager.deleteUserTemplate(item);
                    ProjectTemplatesPreferencePage.this.templateList.remove(s);
                }
            }
        });
        Label spacer = new Label(column, 16384);
        spacer.setLayoutData((Object)new GridData(1040));
        return field;
    }

    public void init(IWorkbench workbench) {
    }
}

