/*
** tr2latex - troff to LaTeX converter
**
** Module: special.h
**
*/
struct special_table {
	const char *troff_char, *tex_char;
} special [] = {
/*  troff name	TeX name */
   {"em",       "---"},
   {"hy",       "-"},
   {"bu",       "$\\bullet$"},
   {"sq",       "$\\Box$"}, /* needs package latexsym */
   {"ru",       "$\\_$"},
   {"14",       "$\\fraction 1/4$"},
   {"12",       "$\\fraction 1/2$"},
   {"34",       "$\\fraction 3/4$"},
   {"fi",       "fi"},
   {"fl",       "fl"},
   {"ff",       "ff"},
   {"Fi",       "ffi"},
   {"Fl",       "ffl"},
   {"de",       "$^\\circ$"},
   {"dg",       "$\\dagger$"},
   {"fm",       "$\\prime$"},
   {"ct",       "\\textcent"},
   {"rg",       "\\textregistered"},
   {"co",       "\\textcopyright"},
   {"pl",       "$+$"},
   {"mi",       "$-$"},
   {"eq",       "$=$"},
   {"**",       "$\\ast$"},
   {"sc",       "\\textsection"},
   {"aa",       "\\textasciiacute"}, /* needs package textcomp */
   {"ga",       "\\textasciigrave"}, /* needs package textcomp */
   {"ul",       "$\\_$"},
   {"sl",       "$\\/$"},
   {"*a",       "$\\alpha$"},
   {"*b",       "$\\beta$"},
   {"*g",       "$\\gamma$"},
   {"*d",       "$\\delta$"},
   {"*e",       "$\\epsilon$"},
   {"*z",       "$\\zeta$"},
   {"*y",       "$\\eta$"},
   {"*h",       "$\\theta$"},
   {"*i",       "$\\iota$"},
   {"*k",       "$\\kappa$"},
   {"*l",       "$\\lambda$"},
   {"*m",       "$\\mu$"},
   {"*n",       "$\\nu$"},
   {"*c",       "$\\xi$"},
   {"*o",       "o"},
   {"*p",       "$\\pi$"},
   {"*r",       "$\\rho$"},
   {"*s",       "$\\sigma$"},
   {"ts",       "$\\varsigma$"},
   {"*t",       "$\\tau$"},
   {"*u",       "$\\upsilon$"},
   {"*f",       "$\\phi$"},
   {"*x",       "$\\chi$"},
   {"*q",       "$\\psi$"},
   {"*w",       "$\\omega$"},
   {"*G",       "$\\Gamma$"},
   {"*D",       "$\\Delta$"},
   {"*Y",       "$H$"},
   {"*H",       "$\\Theta$"},
   {"*L",       "$\\Lambda$"},
   {"*C",       "$\\Xi$"},
   {"*P",       "$\\Pi$"},
   {"*R",       "$P$"},
   {"*S",       "$\\Sigma$"},
   {"*U",       "$\\Upsilon$"},
   {"*F",       "$\\Phi$"},
   {"*Q",       "$\\Psi$"},
   {"*W",       "$\\Omega$"},
   {"sr",       "$\\surd$"},
    /*"rn",       "$\\`$",*/
   {">=",       "$\\geq$"},
   {"<=",       "$\\leq$"},
   {"==",       "$\\equiv$"},
   {"|=",       "$\\simeq$"},
   {"ap",       "$\\sim$"},
   {"!=",       "$\\neq$"},
   {"->",       "$\\to$"},
   {"<-",       "$\\gets$"},
   {"ua",       "$\\uparrow$"},
   {"da",       "$\\downarrow$"},
   {"mu",       "$\\times$"},
   {"di",       "$\\div$"},
   {"+-",       "$\\pm$"},
   {"cu",       "$\\cup$"},
   {"ca",       "$\\cap$"},
   {"sb",       "$\\subset$"},
   {"sp",       "$\\supset$"},
   {"ib",       "$\\subseteq$"},
   {"ip",       "$\\supseteq$"},
   {"if",       "$\\infty$"},
   {"pd",       "$\\partial$"},
   {"gr",       "$\\nabla$"},
   {"no",       "$\\neg$"},
   {"is",       "$\\int$"},
   {"pt",       "$\\propto$"},
   {"es",       "$\\emptyset$"},
   {"mo",       "$\\in$"},
   {"br",       "$\\vert$"},
   {"dd",       "$\\ddagger$"},
   {"rh",       "$\\Rightarrow$"},
   {"lh",       "$\\Leftarrow$"},
 /*{"bs",       ""},*/
   {"or",       "$\\vert$"},
   {"ci",       "$\\bigcirc$"},
 /*{"lt",       "$\\$"},
   {"lb",       "$\\$"},
   {"rt",       "$\\$"},
   {"rb",       "$\\$"},
   {"lk",       "$\\$"},
   {"rk",       "$\\$"},*/
   {"bv",       "$\\bracevert$"},
   {"lf",       "$\\lfloor$"},
   {"rf",       "$\\rfloor$"},
   {"lc",       "$\\lceil$"},
   {"rc",       "$\\rceil$"}
};