//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 27th September, 2014
//
//
package worker4math.hktex2;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import android.os.Bundle;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.view.MotionEvent;
import android.view.View;


public class Displayportrait extends Activity {
	
    Canvas canvas = new Canvas();
    Drawdocument drawdocument = new Drawdocument();
    public static int contentViewTop=0;
    public static int contentViewBottom= 0;
    public static int height=0;
    public static int width=0;
    public static int tid=0;
    public static Bitmap larrow;
    public static Bitmap rarrow;
    public static Bitmap lendarrow;
    public static Bitmap rendarrow;
    public int showpage=0;
	ArrayList<Typeface> tf = new ArrayList<Typeface>();
    public Integer containerwidth;
    public Integer containerheight;
    Boolean parsed=false;
    Boolean firstdraw=true;
    InputStream bitmapstream=null;
    DocumentBitmap documentbitmap = new DocumentBitmap();
	Paint rpaint = new Paint();
	Rect rect = new Rect();
	
	@Override
	  public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
	    setContentView(new SampleView1(this));        
	    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        larrow = BitmapFactory.decodeResource(getResources(), R.drawable.leftarrow);  
        rarrow = BitmapFactory.decodeResource(getResources(), R.drawable.rightarrow);  
        lendarrow = BitmapFactory.decodeResource(getResources(), R.drawable.leftendarrow);  
        rendarrow = BitmapFactory.decodeResource(getResources(), R.drawable.rightendarrow);
        documentbitmap.documentbitmap();
    	 
        for (int i=0;i<=DocumentBitmap.bitmapname.size()-1;i++){
        try {
            bitmapstream=getAssets().open("bitmap/"+DocumentBitmap.bitmapname.get(i));
            DocumentBitmap.bitmap.put(DocumentBitmap.bitmapname.get(i),BitmapFactory.decodeStream(bitmapstream));
        } catch (IOException e) {
            e.printStackTrace();
        } }
	  }
	  
	  private class SampleView1 extends View {
	    public SampleView1(Context context) {
	      super(context);	      
	    }
    	  
	    
	    @Override
	    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
	        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
	        containerwidth = MeasureSpec.getSize(widthMeasureSpec);
	        containerheight = MeasureSpec.getSize(heightMeasureSpec);	     
	        rect.set(0,0,containerwidth,containerheight);
	    	rpaint.setColor(Color.WHITE);
	    }
	    
	    public boolean onTouchEvent(MotionEvent event) {
	
	  	    	float eventX = event.getX();
	  	        float eventY = event.getY();
	  	        int pagenumber;
	  	        if ((Header.tablet && Header.tablet_twocolumns) || (!Header.tablet && Header.phone_twocolumns)){
	  	        pagenumber=Initdraw.pagenumber/2;}
	  	        else {
	  	        	pagenumber=Initdraw.pagenumber;
	  	        }
	  	        if(event.getAction()==MotionEvent.ACTION_DOWN){
		            if(eventX >= containerwidth/3-larrow.getWidth()/2 && eventX <= containerwidth/3+larrow.getWidth()/2 && eventY >= containerheight-larrow.getHeight() && eventY <= containerheight) {
		            	if (Drawdocument.showpagenumber > 0) {
		                    Drawdocument.showpagenumber--;	          		                    
		                    invalidate();
		    	            	}
		            } else if (eventX >= containerwidth*2/3-rarrow.getWidth()/2 && eventX <= containerwidth*2/3+rarrow.getWidth()/2 && eventY >= containerheight-rarrow.getHeight() && eventY <= containerheight){
		            	if (Drawdocument.showpagenumber < pagenumber) {
		                    Drawdocument.showpagenumber++;	         		                    
		                    invalidate();
		    	            	}
		            }else if (eventX >= 10 && eventX <= lendarrow.getWidth()+10 && eventY >= containerheight-lendarrow.getHeight() && eventY <= containerheight){		            	
		                    Drawdocument.showpagenumber=0;	         		                    
		                    invalidate();		    	            	
		            }else if (eventX >= containerwidth-rendarrow.getWidth()-10 && eventX <= containerwidth-10 && eventY >= containerheight-rendarrow.getHeight() && eventY <= containerheight){		            	
	                    Drawdocument.showpagenumber=pagenumber;	         		                    
	                    invalidate();		    	            	
	            }
	            }	  	    	

	  	        return true;
	  }
@Override
	public void onDraw(Canvas canvas) {	
    
		if (firstdraw){drawdocument.drawinit(containerwidth, containerheight); firstdraw=false;}
	
		tf.add(Typeface.SERIF);
		tf.add(Typeface.create(Typeface.SERIF,Typeface.ITALIC));
		tf.add(Typeface.DEFAULT_BOLD);
		tf.add(Typeface.MONOSPACE);	    	
		tf.add(Typeface.createFromAsset(getAssets(),"fonts/asana-math.ttf"));   //   Math symbols
		tf.add(Typeface.SERIF);   // For the moment, use serif instead
 

		canvas.drawRect(rect, rpaint);
		drawdocument.drawdocument(canvas, tf, containerwidth);	                
	     	 
		canvas.drawBitmap(larrow, containerwidth/3-larrow.getWidth()/2, containerheight-larrow.getHeight(), null);            
		canvas.drawBitmap(rarrow, containerwidth*2/3-rarrow.getWidth()/2, containerheight-rarrow.getHeight(), null);
		canvas.drawBitmap(lendarrow, 10, containerheight-lendarrow.getHeight(), null);            
		canvas.drawBitmap(rendarrow, containerwidth-rendarrow.getWidth()-10, containerheight-rendarrow.getHeight(), null);
	         
	} }
	  
}
