#ifndef __WIN32BIT__

/* 16 bit defs */
#include <string.h>
#define LSRCCPY(dest,src,bytes)     _fmemcpy(dest,(void far *)src,bytes)
#define LDSTCPY(dest,src,bytes)     _fmemcpy((void far *)dest,src,bytes)
#define LSTRCPY(src,dest)	    _fstrcpy(src,dest)
#define STR2LONG(addr)		    (LONG)(LPSTR)(addr)
#define FAR2PTR(addr)		    (void far *)(addr)
#define LONG2PTR(addr)		    (void far *)(addr)

typedef int INT;

#else

/* 32 bit defs */
#define LSRCCPY(dest,src,bytes)     _memcpy_from_far(dest,(unsigned long)(src),bytes)
#define LDSTCPY(dest,src,bytes)     _memcpy_to_far((unsigned long)(dest),src,bytes)
#define LSTRCPY(dest,src)	    _strcpy_from_far(dest,(unsigned long)(src))
#define STR2LONG(addr)		    _rsx_32to16(addr)
#define FAR2PTR(addr)		    _rsx_16to32((unsigned long)(addr))
#define LONG2PTR(addr)		    _rsx_16to32(addr)

#if defined (__cplusplus)
extern "C" {
#endif

/* 32 bit functions */
void * _memcpy_from_far(void *offset32, unsigned long far16, unsigned short bytes);
void * _memcpy_to_far(unsigned long far16, void *offset32, unsigned short bytes);
void * _strcpy_from_far(void *offset32, unsigned long far16);
unsigned long _rsx_32to16(void * addr);
void * _rsx_16to32(unsigned long fp);

#if defined (__cplusplus)
}
#endif

#endif
