/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import java.io.Serializable;
import nts.io.Log;
import nts.io.Loggable;
import nts.node.Hyphens;

public abstract class Language
implements Serializable,
Loggable {
    public static final Language NULL;
    public static final char WORD_BOUNDARY = '\u0000';
    protected final int languageNumber;
    protected final int leftHyphenMin;
    protected final int rightHyphenMin;

    public boolean isCommon() {
        return this.languageNumber == 0 && this.leftHyphenMin == 2 && this.rightHyphenMin == 3;
    }

    public void addOn(Log log) {
        log.add("language").add(this.languageNumber).add(":hyphenmin").add(this.leftHyphenMin).add(',').add(this.rightHyphenMin);
    }

    public void addShortlyOn(Log log) {
        log.add(this.languageNumber).add(" (hyphenmin ").add(this.leftHyphenMin).add(',').add(this.rightHyphenMin).add(')');
    }

    public boolean isZero() {
        return this.languageNumber == 0;
    }

    public void addNumberOn(Log log) {
        log.add(this.languageNumber);
    }

    public boolean sameNumberAs(int number) {
        return this.languageNumber == number;
    }

    public abstract Hyphens getHyphens(String var1);

    public abstract void setHyphException(String var1, int[] var2);

    public abstract boolean setHyphPattern(String var1, int[] var2);

    public Language(int ln, int lhm, int rhm) {
        this.languageNumber = ln;
        this.leftHyphenMin = lhm;
        this.rightHyphenMin = rhm;
    }
}

