/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import java.util.Vector;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.Prim;
import nts.command.Token;
import nts.io.CharCode;
import nts.typo.TypoAssignPrim;
import nts.typo.TypoCommand;

public class PatternsPrim
extends TypoAssignPrim {
    private static final char WORD_BOUNDARY = '\u0000';

    protected void assign(Token src, boolean glob) {
        TypoCommand.Config cfg = TypoCommand.getTypoConfig();
        if (!cfg.patternsAllowed()) {
            if (CommandBase.getConfig().formatLoaded()) {
                CommandBase.error("CantLoadPatterns");
                while (!CommandBase.nextRawToken().matchRightBrace()) {
                }
            } else {
                CommandBase.error("LatePatterns", this);
                Prim.scanTokenList(src, false);
            }
            return;
        }
        CommandBase.scanLeftBrace();
        StringBuffer buf = new StringBuffer();
        Vector<Integer> valBuf = new Vector<Integer>();
        boolean digitExpected = true;
        while (true) {
            CharCode toAdd;
            Token tok;
            Command cmd;
            CharCode code;
            if ((code = (cmd = CommandBase.meaningOf(tok = CommandBase.nextExpToken())).charCode()) != null && (toAdd = cmd.charCodeToAdd()) != null && code.match(toAdd)) {
                char letter;
                int index;
                char chr = code.toChar();
                if (digitExpected && chr >= '0' && chr <= '9') {
                    index = buf.length();
                    if (index >= valBuf.size()) {
                        valBuf.setSize(index + 1);
                    }
                    valBuf.set(index, new Integer(chr - 48));
                    digitExpected = false;
                    continue;
                }
                if (code.match('.')) {
                    index = 0;
                } else {
                    letter = code.toCanonicalLetter();
                    if (letter == '\uffff') {
                        CommandBase.error("NonLetter");
                        letter = '\u0000';
                    }
                }
                buf.append(letter);
                digitExpected = true;
                continue;
            }
            if (cmd.isSpacer() || cmd.isRightBrace()) {
                int size = buf.length();
                if (size > 0) {
                    int[] values = new int[valBuf.size()];
                    int i = 0;
                    while (i < values.length) {
                        Integer val = (Integer)valBuf.get(i);
                        values[i] = val != null ? val : 0;
                        ++i;
                    }
                    if (values.length > 0 && size > 0) {
                        if (buf.charAt(0) == '\u0000') {
                            values[0] = 0;
                        }
                        if (buf.charAt(size - 1) == '\u0000' && values.length > size) {
                            values[size] = 0;
                        }
                    }
                    if (!cfg.getLanguage().setHyphPattern(buf.toString(), values)) {
                        CommandBase.error("DupPattern");
                    }
                    buf.setLength(0);
                    valBuf.clear();
                }
                if (cmd.isRightBrace()) break;
                digitExpected = true;
                continue;
            }
            CommandBase.error("BadPatterns", this);
        }
    }

    public PatternsPrim(String name) {
        super(name);
    }
}

