/* #module	IdxCmd		"3-001"
 ***********************************************************************
 *                                                                     *
 * The software was developed at the Monsanto Company and is provided  *
 * "as-is".  Monsanto Company and the auther disclaim all warranties   *
 * on the software, including without limitation, all implied warran-  *
 * ties of merchantabilitiy and fitness.                               *
 *                                                                     *
 * This software does not contain any technical data or information    *
 * that is proprietary in nature.  It may be copied, modified, and     *
 * distributed on a non-profit basis and with the inclusion of this    *
 * notice.                                                             *
 *                                                                     *
 ***********************************************************************
 */
/*
 * Module Name:	IdxCmd
 *
 * Author:	R L Aurbach	CR&DS MIS Group	    13-Jun-1986
 *
 * Function:
 *
 *	This routine parses the IdxTeX Command Line, and returns the name of
 *	the input file and a flag which indicates whether to add an entry to
 *	the table of contents for the Index.
 *
 * Modification History:
 *
 * Version     Initials	   Date		Description
 * ------------------------------------------------------------------------
 * 1-001	RLA	13-Jun-1986	Original Code, based on the CRDVLIB
 *					Library routine LIB_PARSE_FOREIGN
 * 2-002	RLA	09-Apr-1987	Add support for the /MASTER qualifier
 * 3-001	F.H.	17-May-1991	converted to portable C
 */
/*
 * Module IdxCmd - Module-Wide Data Description Section
 *
 * Include Files:
 */
#ifdef MSDOS
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#define F_OK		0	/* access(): File exists */
#else
#include <sys/file.h>
extern char *sprintf();
#endif
#include <string.h>
#include "IdxDef.h"
/*
 * Module Definitions:
 */

#define TRUE	1	/* Success value */
#define FALSE	0	/* Failure value */
/*
 * Global Declarations:
 */
/*
 * Static Declarations:
 */
#ifdef MSDOS
void idx_command(int argc, char *argv[], char *file,
	int *toc_flag, int *mst_flag);
#else
void idx_command();
#endif
/*
 * External References:
 */
/*
 * Functions Called:
 */
/*
 * Function Idx_Commmand - Documentation Section
 *
 * Discussion:
 *	This routine uses lib$get_foreign to read the command line.  It 
 *	prefixes the command line with "IdxTeX ", so that the CLI routines
 *	will have the appropriate information on which to operate.  It then
 *	parses the command line and returns the appropriate information to the
 *	program.
 *
 *	Since this routine establishes LIB$SIG_TO_STOP as a condition handler,
 *	syntax errors detected during processing result in program exit.
 *
 * Calling Synopsis:
 *	Call Idx_Command (file, toc_flag, mst_flag)
 *
 * Inputs:
 *	none
 *
 * Outputs:
 *	file	    ->	is the input file specified in the command line.  This
 *			is a required parameter.  This variable is an ASCIZ
 *			string passed by reference.  The calling program is
 *			responsible for allocating a sufficiently large 
 *			string (i.e., char file[256]).
 *
 *	toc_flag    ->	indicates whether the /TOC qualifier was specified.
 *			Values returned are:
 *			    IDX_K_NONE    - /TOC not specified.
 *			    IDX_K_ARTICLE - /TOC:ARTICLE specified.
 *			    IDX_K_REPORT  - /TOC:REPORT specified.
 *
 *	mst_flag    ->	indicates whether the /MASTER qualifier was specified.
 *			Returns a boolean result.
 *
 * Return Value:
 *	none
 *
 * Global Data:
 *	none
 *
 * Files Used:
 *	none
 *
 * Assumed Entry State:
 *	IdxTeX is invokes as a Foreign DCL command.
 *
 * Normal Exit State:
 *	Routine returns to caller.  The "file", "toc_flag", and "mst_flag"
 *	variables are set up correctly.
 *
 * Error Conditions:
 *	Since the routine establishes LIB$SIG_TO_STOP as its exception handler,
 *	syntax and parsing errors detected by the CLI$ routines (which signal
 *	errors) cause the program to exit.  That is, all syntax errors are	
 *	fatal.
 *
 * Algorithm:
 *	A. Call Lib$Get_Foreign to retrieve the command line.
 *	B. Prefix the command line with the command verb.
 *	C. Call Cli$DCL_Parse to parse the command line.
 *	D. Process the file name.
 *	    1. Get the file name.
 *	    2. Convert it to an ASCIZ string.
 *	E. Process the /TOC qualifier.
 *	    1. If /TOC is not specified,
 *		a. toc_flag = IDX_K_NONE.
 *	    2. If /TOC:ARTICLE specified,
 *		a. toc_flag = IDX_K_ARTICLE.
 *	    3. If /TOC:REPORT specified.
 *		a. toc_flag = IDX_K_REPORT.
 *	F. Process the /MASTER qualifier.
 *
 * Special Notes:
 *	This routine is based on the LIB_PARSE_FOREIGN routine, suitably
 *	modified.
 */
/*
 * Function Idx_Command - Code Section
 */
void idx_command (argc, argv, file, toc_flag, mst_flag)
     int  argc;
     char *argv[];
     char *file;	/* File name parameter		*/
     int  *toc_flag;	/* /TOC flag			*/
     int  *mst_flag;	/* /MASTER flag			*/
{
/*
 * Local Declarations:
 */
	int   i;
/*
 * Module Body:
 */
/* Establish a condition handler */ 
/* Get the command line		 */
/* Parse the command line	 */
/* Get the filename string	 */
  (void)sprintf(file,"%s", argv[1]);
/* Process the /TOC qualifier	 */
  i = 2;
  *toc_flag = IDX_K_NONE;
  if (argc > i) {
    if ((strncmp("/TOC", argv[i],4)) == 0) {
      if (argv[i][5] == 'A')  *toc_flag = IDX_K_ARTICLE;
      if (argv[i][5] == 'R')  *toc_flag = IDX_K_REPORT;
      i++;
    }
  }
/* Process the /MASTER qualifier */
  *mst_flag = FALSE;
  if (argc > i)
    if (strncmp("/MASTER",argv[i],7) == 0) *mst_flag = TRUE;
}
