/*
 * cc2tex1.3 - program to put Chinese character into latex
 *
 * Zhi Biao Wu
 * Department of Information System & Computer Science 
 * Natural University of Singapore
 * 1992
 *
 * Copyright (c) 1992, Zhi Biao Wu,ISCS,NUS.
 * All rights reserved.
 *
 * Use and copying of this software and preparation of derivative works
 * based upon this software are permitted.  However, any distribution of
 * this software or derivative works must include the above copyright
 * notice.
 *
 * This software is made available AS IS, and neither the Department of 
 * Information system & Computer Science or the writer make any
 * warranty about the software, its performance or its conformity to
 * any specification.
 */

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "copyright.h"

#define JIANTI          0x01
#define JAPANESE        0x04
#define FANTI           0x02
#define CHIJAN          0x08
#define MAXCCLENGTH	50

extern char *header[6];

char * get_str(), * loadccfont();
unsigned char *s2c();

int xx0,yy0;
int podd,tmp,pspoint;
char ccfname[10];
unsigned char pstr[300];
char g_ccfname[10];
char texname[30];
unsigned char c,pre_c;
char ccstr[6];
int i,j,k,f_ord,ccfontdotwidth,g_ccfontdotwidth;
FILE * texfile;
int ccfd;
unsigned char ccc[2];
struct stat st;
char *g_ccimage;
char *ccimage;
long texlength,read_pos,cclength;
int l_mode,font_w,font_h;
char g_cc[200];
int g_rotate;
int g_direction; /* 0 -> 1 V*/
int g_interval;  /* interval between two character strings*/
char g_newcc[20];
float g_linewidth;
char g_h[20],g_w[20];

char cc[200];
int rotate;
int direction; /* 0 -> 1 V*/
int interval;  /* interval between two character strings*/
char newcc[20];
float linewidth;
char h[20],w[20];
int exec_num;
int idraw_format; /* PostScript idraw format */
int nops; /* No output of cctex*.ps file */

main(argc,argv)
int argc;
char ** argv;
{

    if (argc == 1) {
	printf("Cc2Tex 1.3 Copyright (C) 1992, ");
	printf("Zhi Biao Wu, All rights reserved.\n");
	printf("cc2tex comes with NO WARRANTY: see the file COPYRIGHT for details.\n");
	exit();
    }
    exec_num = 0;
    idraw_format = 0;
    nops = 0;
    pre_c = 0;
    for (i=1; i<argc; i++) {
	switch (argv[i][0]) {
	    case '-' : 
		if (strcmp(argv[i],"-asc") == 0) exec_num = 1;
		if (strcmp(argv[i],"-nops") == 0) nops = 1;
		if (strcmp(argv[i],"-idraw") == 0) idraw_format = 1;
		break;
	    default:
    		strcpy(texname, argv[i]);
	}
    }

    if (exec_num == 1) main1();
    else main2();
}


main1()
{
    char reg[3];

    if ((ccfd = open(texname,O_RDONLY)) == NULL ) {
	printf("Can't open file: %s\n",texname);
	exit(1);
    }
    fstat(ccfd,&st);
    texlength = st.st_size;
    close(ccfd);
    if ((texfile = fopen(texname,"r")) == NULL ) {
	printf("Can't open file: %s\n",texname);
	exit(1);
    }
    while (read_pos < texlength) {
    	c = fgetc(texfile);
	read_pos++;
	if (c >= 0xa0) {
	    pstr[pspoint++] = c;
	    if (pspoint == MAXCCLENGTH) {
		    for (i = 0; i < pspoint; i++) {
			sprintf(&cc[i*2],"%x", pstr[i]);
		    }
		    if (strcmp(reg,"cc=") != 0) 
			printf("\%\%cctext{cc=%s}",cc);
		    else
			printf("%s",cc);
		    pspoint = 0;
		    reg[2] = 0;
	    }
	} else {
	    if (pspoint != 0) {
	   	if (pspoint & 1 != 0) {
		    printf("Chinese code error %s\n",pstr);
		    exit(1);
		} else {
		    for (i = 0; i < pspoint; i++) {
			sprintf(&cc[i*2],"%x", pstr[i]);
		    }
		    if (strcmp(reg,"cc=") != 0) 
			printf("\%\%cctext{cc=%s}",cc);
		    else
			printf("%s",cc);
		    pspoint = 0;
		    reg[2] = 0;
		}
	    }
	    reg[0] = reg[1];
	    reg[1] = reg[2];
	    reg[2] = c;
	    printf("%c",c);
	}
	pre_c = c;
    }
    fclose(texfile);
}


main2()
{
    f_ord = 0;
    if ((ccfd = open(texname,O_RDONLY)) == NULL ) {
	printf("Can't open file: %s\n",texname);
	exit(1);
    }
    fstat(ccfd,&st);
    texlength = st.st_size;
    close(ccfd);
    if ((texfile = fopen(texname,"r")) == NULL ) {
	printf("Can't open file: %s\n",texname);
	exit(1);
    }

    strcpy(g_cc,"d1a9c4e0bae8d7a6c7d9c6e5cae9bda3");
    g_linewidth = 1.0;
    linewidth = 1.0;
    rotate = 0;
    g_rotate = 0;
    interval = 0;
    g_interval = 0;
    direction = 0;
    g_direction = 0;
    strcpy(h,"NULL");
    strcpy(g_h,"NULL");
    strcpy(w,"NULL");
    strcpy(g_w,"NULL");
    strcpy(g_ccfname,"clib.24");
    g_ccimage = loadccfont(g_ccfname);
    g_ccfontdotwidth = ccfontdotwidth;

    pspoint = 0;
    read_pos = 0;
    strcpy(pstr,"");
    while (read_pos < texlength) {
    	c = fgetc(texfile);
	read_pos++;
	if (c >= 0xa0) {
	    pstr[pspoint++] = c;
	} else {
	    if (pspoint != 0) {
	   	if (pspoint & 1 != 0) {
		    printf("Chinese code error %s\n",pstr);
		    exit(1);
		} else {
		    for (i = 0; i < pspoint; i++) {
			sprintf(&cc[i*2],"%x", pstr[i]);
		    }
		    f_ord++;
    			linewidth = g_linewidth ;
    			rotate = g_rotate;
    			interval = g_interval;
    			direction = g_direction;
    			strcpy(h,g_h);
    			strcpy(w,g_w);
    			strcpy(ccfname,g_ccfname);
    			ccimage = g_ccimage;
    			ccfontdotwidth = g_ccfontdotwidth;

		    change();
		    pspoint = 0;
		}
	    }
	 if ((c != '%') || ((c == '%') && (pre_c == '+'))) {
	    printf("%c",c);
	 } else {
	    for (i = 0; i < 6; i++) {
	   	read_pos++;
		ccstr[i] = fgetc(texfile);
 	    }
	    if (strcmp(ccstr,"cctext") == 0) {
		f_ord++;
    		set_local();
		change();
	    } else if (strcmp(ccstr,"ccglob") == 0) {
		set_global();
	    } else {
		printf("%c",c);
	    	for (i = 0; i < 6; i++)
		    printf("%c", ccstr[i]);
	    }
	 }
	}
	pre_c = c;
    }
    fclose(texfile);
}

set_global()
{
    char tmpname[30],tmpstr[300];
    FILE * tmpfile;

    read_pos++;
    c = fgetc(texfile);
    if (c != '{') {
	printf("cctext format error!\n");
	exit(1);
    }
    i = 0;
    strcpy(pstr,"");
    do {
	read_pos++;
      	c = fgetc(texfile);
	pstr[i++] = c;
    } while (c != '}');
    pstr[i] = 0;
    if (get_str(pstr,"cc=") != NULL ) {
	strcpy(g_cc,get_str(pstr,"cc="));
    }
    if (get_str(pstr,"linewd=") != NULL ) {
	strcpy(tmpstr,get_str(pstr,"linewd="));
	sscanf(tmpstr,"%f",&g_linewidth);
    }
    if (get_str(pstr,"height=") != NULL ) 
	strcpy(g_h, get_str(pstr,"height="));
    if (get_str(pstr,"width=") != NULL )  
	strcpy(g_w, get_str(pstr,"width="));
    if (get_str(pstr,"ccfname=") != NULL )  { 
	strcpy(g_newcc, get_str(pstr,"ccfname="));
	if (strcmp(g_ccfname,g_newcc) != 0)  {
	    strcpy(g_ccfname,g_newcc);
            free(g_ccimage);
	    g_ccimage = loadccfont(g_ccfname);
	    g_ccfontdotwidth = ccfontdotwidth;
	}
    }
    if (get_str(pstr,"interval=") != NULL ) {
	strcpy(tmpstr,get_str(pstr,"interval="));
	sscanf(tmpstr,"%d",&g_interval);
    }
    if (get_str(pstr,"direction=") != NULL ) {
	strcpy(tmpstr,get_str(pstr,"direction="));
	sscanf(tmpstr,"%d",&g_direction);
    }
    if (get_str(pstr,"rotate=") != NULL ) {
	strcpy(tmpstr,get_str(pstr,"rotate="));
	sscanf(tmpstr,"%d",&g_rotate);
    }
    strcpy(cc,g_cc);
    linewidth = g_linewidth ;
    rotate = g_rotate;
    interval = g_interval;
    direction = g_direction;
    strcpy(h,g_h);
    strcpy(w,g_w);
    strcpy(ccfname,g_ccfname);
    ccimage = g_ccimage;
    ccfontdotwidth = g_ccfontdotwidth;
}

set_local()
{
    char tmpname[30],tmpstr[300];
    FILE * tmpfile;

	read_pos++;
    	c = fgetc(texfile);
    	if (c != '{') {
		printf("cctext format error!\n");
		exit(1);
    	}
    	i = 0;
        strcpy(pstr,"");
    	do {
		read_pos++;
      		c = fgetc(texfile);
		pstr[i++] = c;
    	} while (c != '}');
    pstr[i] = 0;
    strcpy(cc,g_cc);
    linewidth = g_linewidth ;
    rotate = g_rotate;
    interval = g_interval;
    direction = g_direction;
    strcpy(h,g_h);
    strcpy(w,g_w);
    strcpy(ccfname,g_ccfname);
    ccimage = g_ccimage;
    ccfontdotwidth = g_ccfontdotwidth;

    if (get_str(pstr,"cc=") != NULL ) {
	strcpy(cc,get_str(pstr,"cc="));
    }
    if (get_str(pstr,"linewd=") != NULL ) {
	strcpy(tmpstr,get_str(pstr,"linewd="));
	sscanf(tmpstr,"%f",&linewidth);
    }
    if (get_str(pstr,"height=") != NULL ) 
	strcpy(h, get_str(pstr,"height="));
    if (get_str(pstr,"width=") != NULL )  
	strcpy(w, get_str(pstr,"width="));
    if (get_str(pstr,"ccfname=") != NULL )  { 
	strcpy(newcc, get_str(pstr,"ccfname="));
	if (strcmp(ccfname,newcc) != 0)  {
	    strcpy(ccfname,newcc);
            if (ccimage != g_ccimage) free(ccimage);
	    ccimage = loadccfont(ccfname);
	}
    }
    if (get_str(pstr,"rotate=") != NULL ) {
	strcpy(tmpstr,get_str(pstr,"rotate="));
	sscanf(tmpstr,"%d",&rotate);
    }
    if (get_str(pstr,"interval=") != NULL ) {
	strcpy(tmpstr,get_str(pstr,"interval="));
	sscanf(tmpstr,"%d",&interval);
    }
    if (get_str(pstr,"direction=") != NULL ) {
	strcpy(tmpstr,get_str(pstr,"direction="));
	sscanf(tmpstr,"%d",&direction);
    }
    if (ccfontdotwidth == 16) direction = 1;
}

change()
{
    char tmpname[30],tmpstr[200];
    FILE * tmpfile;
    int fontw,fonth;
    int i,imageh,imagew;


    if (strlen(cc) >= 200) {
	printf("Too many characters!\n");
	exit(1);
    }
    if (direction == 0) {
	    imageh = ccfontdotwidth;
	    imagew = ccfontdotwidth * strlen(cc) / 4 + interval * (strlen(cc) / 4 - 1);
    } else {
	    imagew = ccfontdotwidth;
	    imageh = ccfontdotwidth * strlen(cc) / 4 + interval * (strlen(cc) / 4 - 1);
    }

    sprintf(tmpname, "cctex%d.ps", f_ord);
  if (nops == 0) {
    if ((tmpfile = fopen(tmpname,"w")) == NULL ) {
	printf("Can't open file: %s\n",tmpname);
	exit(1);
    }

    fprintf(tmpfile,"\%\%\!PS-Adobe-2.0 EPSF-1.2\n");
    if (idraw_format) 
    	fprintf(tmpfile,"\%\%\%\%Creator: idraw\n");
    else
    	fprintf(tmpfile,"\%\%\%\%Creator: cc2tex\n");
    fprintf(tmpfile,"\%\%\%\%DocumentFonts:\n");
    fprintf(tmpfile,"\%\%\%\%Pages: 1\n");

    fprintf(tmpfile,"\%\%\%\%BoundingBox: ");
    if (idraw_format == 0) {
     	fprintf(tmpfile,"0 0 %d %d\n",imagew - 1,imageh - 1);
     	fprintf(tmpfile,"%f setlinewidth\n",linewidth);
    } else if (ccfontdotwidth == 128) {
        fprintf(tmpfile,"0 0 %d %d\n", (int) (0.1 * imagew) + 1, (int) (0.1 * imageh) + 1);
	for (i=0; header[i][0]>0; i++) {
	    fputs(header[i],tmpfile);
	}
    } else {
	if (ccfontdotwidth == 16)
            fprintf(tmpfile,"0 0 %d %d\n", (int) (0.5*imagew),(int)(0.5*imageh));
	else
            fprintf(tmpfile,"0 0 %d %d\n", (int)(0.5*imagew),(int)(0.5*imageh));
	for (i=0; header[i][0]>0; i++) {
	    fputs(header[i],tmpfile);
	}
    }
    if (ccfontdotwidth == 128) {
	if (direction == 1) {
	    xx0 = 0;
	    yy0 = imageh - 1 - ccfontdotwidth;
	} else {
	    xx0 = 0;
	    yy0 = 0;
	}
    } else {
      if (idraw_format) {
	fprintf(tmpfile,"Begin \%\%I SSten\n");
	fprintf(tmpfile,"\%\%I cfg #000000\n");
	fprintf(tmpfile,"0 0 0 SetCFg\n");
	fprintf(tmpfile,"\%\%I cbg #ffffff\n");
	fprintf(tmpfile,"1 1 1 SetCBg\n");
	fprintf(tmpfile,"\%\%I t\n");
      }
      if (ccfontdotwidth == 16) {
	if (idraw_format) 
		fprintf(tmpfile,"[ 5 0 0 5 0 0] concat\n");
        else {
	    fprintf(tmpfile,"0 %d translate %d rotate %d %d scale\n",
		imageh - 1 - ccfontdotwidth,rotate,
		ccfontdotwidth,ccfontdotwidth);
	    fprintf(tmpfile,"%d %d 1 [16 0 0 -16 0 16] ",
		ccfontdotwidth,
		ccfontdotwidth * strlen(cc) / 4 + interval * (strlen(cc) / 4 - 1));
        }
      	xx0 = 0;
    	yy0 = imageh - 1 - ccfontdotwidth;
      } else {
      	if (idraw_format)
		fprintf(tmpfile,"[ 0 -5 -5 0 %d %d] concat\n",
			5*imagew,5*imageh);
      	else {
	     fprintf(tmpfile,"%d rotate %d %d scale\n",
		rotate - 90,ccfontdotwidth,ccfontdotwidth);
	     fprintf(tmpfile,"%d %d 1 [24 0 0 24 24 0] ",
		ccfontdotwidth,
		ccfontdotwidth * strlen(cc) / 4 + interval * (strlen(cc) / 4 - 1));
      	}
	xx0 = 0;
	yy0 = 0;
      }
      if (idraw_format) {
	fprintf(tmpfile,"\%\%I\n%d %d SSten { currentfile %d string readhexstring pop }\n",
		ccfontdotwidth,	ccfontdotwidth * strlen(cc) / 4 + interval
		 * (strlen(cc) / 4 - 1), ccfontdotwidth/8);
	fprintf(tmpfile,"imagemask\n");
      } else 
	fprintf(tmpfile,"{<");
    }
    wrtexts(tmpfile,cc);
    if (ccfontdotwidth == 128) {
	if (idraw_format) 
		fprintf(tmpfile,"\nEnd \%\%I eop\n\nshowpage\n\n\%\%\%\%Trailer\n\nend\n");
	else
        fprintf(tmpfile,"showpage\n");
    } else {
      if (idraw_format)
	fprintf(tmpfile,"End\n\nEnd \%\%I eop\n\nshowpage\n\n\%\%\%\%Trailer\n\nend\n");
      else {
  	fprintf(tmpfile,">} image \n");
        fprintf(tmpfile,"showpage\n");
      }
    }

    fclose(tmpfile);
  }
    printf("\\psfig{figure=%s",tmpname);
    if ((strlen(h) != 0)&& (strcmp(h,"NULL") != 0)) printf(",height=%s",h);
    if ((strlen(w) != 0) && (strcmp(w,"NULL") != 0)) printf(",width=%s",w);
    printf("}");
    
}

char *
get_str(s1,s2)
char * s1, * s2;
{
    char tmpstr[200];
    int i,j,k;
    char *p; 

    if (strstr(s1,s2) != NULL) {
	strcpy(tmpstr,strstr(s1,s2));
	if (strlen(tmpstr) > strlen(s2)) {
	    p = tmpstr;
	    for (j = 0; j < strlen(s2); j++) p++;
	    i = strlen(s2);
	    while ((tmpstr[i] != ',') && (tmpstr[i] != '}') && (i < strlen(tmpstr))) {
		i++;
	    }
            tmpstr[i] = '\0';
	    return(p);
	} else {
	    return(NULL);
	}
    } else {
	return(NULL);
    }
}

char * 
loadccfont(fname)
char *fname;
{
    char fontname[50];
    int i;
    char width[2];
    char *image;

    if (getenv("CCFONT") != NULL )
   	sprintf(fontname,"%s/%s",getenv("CCFONT"),fname);
    else
   	sprintf(fontname,"/usr/lib/ccfonts/%s",fname);
	if ((ccfd = open(fontname,O_RDONLY)) == NULL ) {
		printf("Can't open file: %s\n",fontname);
		exit(1);
	}
	if (fontname[strlen(fontname)-3] != '.') {
		printf("font file name error: %s\n",fontname);
		exit(1);
	}
	width[0]=fontname[strlen(fontname)-2];	
	width[1]=fontname[strlen(fontname)-1];	
	ccfontdotwidth = atoi(width);
	if (ccfontdotwidth == 65) ccfontdotwidth = 128;

	i = strlen(fontname) - 2;
	while (fontname[i] != '/') i--;
	i++;
	switch (fontname[i]) {
		case 'f' :
			l_mode = FANTI;
			break;
		case 'k' :
			l_mode = JAPANESE;
			break;
		case 'h' :
			l_mode = CHIJAN;
			break;
		default :
			l_mode = JIANTI;
	}
	
	
	fstat(ccfd,&st);
	cclength = st.st_size;

	if ((image = (char *) malloc(cclength+1)) == 
		(char *)NULL) {
		printf("ccfont Malloc Error\n");
		exit(1);
	}
	read(ccfd,image,cclength);

	close(ccfd);
	return(image);
}

wrchar(f,cc) 
FILE *f;
unsigned char cc[2];
{
	int i,lcount,leng,fnum,fnum1,jx,jy,
		psx,psy,pointsx[100],pointsy[100];
	unsigned char *image;
	double ang,c1,s1;
	
        if (((cc[0]-0xa0) < 10) || ((cc[0]-0xa0)>15)) {
	 ang=rotate*0.01745;
         c1=cos(ang);
         s1=sin(ang);
	 lcount = 0;
	 image = (unsigned char *)ccimage;
	 if ((cc[0] -0xa0) >= 16)
		 leng = 3*((cc[0] - 0xa7) * 94 + (cc[1] - 0xa1));
	 else	 leng = 3*((cc[0] - 0xa1) * 94 + (cc[1] - 0xa1));
	 fnum = 22845+ image[leng]*0x10000 + image[leng+1] *0x0100+image[leng+2];
	 fnum1 = 22845+ image[leng+3]*0x10000 + image[leng+4] *0x100+image[leng+5];


	 while (fnum<fnum1) {
        	if ((image[fnum] & 0x80)!=0)  {
		    if (lcount != 0) {
		      if (idraw_format) {
			fprintf(f,"Begin \%\%I MLine\n\%\%I b 65535 \n");
			fprintf(f,"0 0 0 [] 0 SetB\n\%\%I cfg Black\n");
			fprintf(f,"0 0 0 SetCFg\n\%\%I cbg White\n");
			fprintf(f,"1 1 1 SetCBg\nnone SetP \%\%I p n\n");
			fprintf(f,"\%\%I t\n[ 1 -0 -0 1 0 0 ] concat\n");
			fprintf(f,"\%\%I %d\n",lcount); 
			for ( i = 0; i < lcount; i++)
		    	    fprintf(f,"%d %d\n", pointsx[i],pointsy[i]);
			fprintf(f, "%d MLine\n", lcount);
			fprintf(f,"\%\%I 1\nEnd\n\n");
		      } else
		      fprintf(f,"stroke\n");
		    }
			lcount = 0;
		}
        	jx=image[fnum] & 0x7f;
        	jy=127 - image[fnum+1];
        	pointsx[lcount]=xx0 + irint(jx*c1-jy*s1);
        	pointsy[lcount]=yy0 + irint(jx*s1+jy*c1);
		fnum = fnum +2;
		psx = pointsx[lcount];
		psy = pointsy[lcount];

		  if (idraw_format == 0)
		    if (lcount == 0) 
		    	fprintf(f,"\%\% Ployline\nnewpath %d %d moveto ",
			psx,psy);
		     else fprintf(f,"%d %d lineto ",psx,psy);

		lcount++;

	 }
	 if (lcount != 0) {
		if (idraw_format) {
			fprintf(f,"Begin \%\%I MLine\n\%\%I b 65535 \n");
			fprintf(f,"0 0 0 [] 0 SetB\n\%\%I cfg Black\n");
			fprintf(f,"0 0 0 SetCFg\n\%\%I cbg White\n");
			fprintf(f,"1 1 1 SetCBg\nnone SetP \%\%I p n\n");
			fprintf(f,"\%\%I t\n[ 1 -0 -0 1 0 0 ] concat\n");
			fprintf(f,"\%\%I %d\n",lcount); 
			for ( i = 0; i < lcount; i++)
		    	    fprintf(f,"%d %d\n", pointsx[i],pointsy[i]);
			fprintf(f, "%d MLine\n", lcount);
			fprintf(f,"\%\%I 1\nEnd\n\n");
			lcount = 0;
		} else
		      fprintf(f,"stroke\n");
	 }
	} else {
		printf("Chinese vector fonts error\n");
		exit();
	}

}
	
wrtexts(f,cstr)
FILE *f;
char *cstr;
{
    int i,j;

    if ((strlen(cstr) & 3 ) != 0) {
	printf("Chinese character code wrong: %s\n",cstr);
	exit(1);
    }
    podd = 0;
    while (podd < strlen(cstr) ) {
	if (podd != 0) {
    	    if (ccfontdotwidth == 128) {
		if (direction == 1) 
		    yy0 -= ccfontdotwidth + interval;
		else
		    xx0 += ccfontdotwidth +  interval;
    	    } else {
		for (i = 0; i < interval; i++) {
		    if (idraw_format) fprintf(f,"\%\%I ");
		    for (j = 0; j < ccfontdotwidth / 8; j++)
		    	if (idraw_format) fprintf(f,"00");
			else fprintf(f,"ff");
		    if (idraw_format) fprintf(f,"\n");
		}
	    }
	}
	tmp = podd;
	s2c(cstr,tmp);
        if (ccfontdotwidth == 128) {
	    wrchar(f,ccc);
	} else {
	    wrfont(f,ccc);
	}
  	podd = podd + 4;
    }
}

wrfont(f,cc)
FILE *f;
unsigned char cc[2];
{
	int pcount, line,colum,xx,yy,x1,y1,i,j,k,p,q,r,testbit;
	long leng;
	unsigned char c;
	char c1,c2;

	if ((cc[0]<=0x80) || (cc[1]<=0x80)) {
		printf("CcFont Error!\n");
		exit(1);
	}
	if (l_mode == CHIJAN) {
		line = cc[0] - 0x81; colum = cc[1]- 0x81;
		leng = (line * 126 + colum ) * 
			 ccfontdotwidth  * ccfontdotwidth/8; 
	} else {
		line = cc[0] - 0xa0; colum = cc[1]- 0xA0;
 		if (line >= 16) line = line - 6;
		leng = ((line - 1) * 94 + colum -1) * 
			 ccfontdotwidth * ccfontdotwidth/8; 
	}
	 xx = 0; 
	 pcount = 0;
         for (i = 0; i <ccfontdotwidth; i++) {
	  if (idraw_format) fprintf(f,"\%\%I ");
          for (j = 0; j <ccfontdotwidth/8; j++) {
	    c = ccimage[leng++];
	    if (idraw_format == 0) c = c ^ 0xff;
	    c2 = c & 0x0000f;
	    c1 = (c & 0x00f0) >> 4;
	    if (c1 < 10) 
	     	fputc(c1 + '0',f);
	    else
		fputc(c1 - 10 + 'a', f);
	    if (c2 < 10) 
	     	fputc(c2 + '0',f);
	    else
		fputc(c2 - 10 + 'a', f);
	  }
	  if (idraw_format) fprintf(f,"\n");
	 }

}

unsigned char *
s2c(s,odd)
char *s;
int odd;
{
    unsigned char c1[2];
    char xx[4];

    xx[0] = '0';
    xx[1] = 'x';
    xx[2] = s[odd];
    xx[3] = s[odd + 1];
    c1[0] = (int) strtol(xx,(char **) NULL, 16);
    xx[2] = s[odd  + 2];
    xx[3] = s[odd + 3];
    c1[1] = (int) strtol(xx,(char **) NULL, 16);

    ccc[1] = c1[1];
    ccc[0] = c1[0];
    return(c1);

}
    

