# This is Makefile for chtext, chtex, chviewer and CzW for BSD and Ultrix
# There are a few  UNIX environment variables0:
# CHTEXTDIC for the path Ci2Dian3.chi (this file is personal, and should be
# readable and writeable).
# DOCLIST the path+filename for document file list used by cdoc
# CCLIB16jt -- bitmap library for 16x16 simplified Chinese fonts
# CCLIB24jt -- bitmap library for 24x24 simplified Chinese fonts
# CCLIB48jt -- bitmap library for 48x48 simplified Chinese fonts
# CCLIB24ft -- bitmap library for 24x24 long-form Chinese fonts
# The following file and directory specifications may need changing at
# your site:
#
SRCPATH=/usr/people/jbw/usr/src/chtex
CCLIBPATH=/usr/people/jbw/usr/src/chtex/cclib
#where are document files to be installed
DOCPAATH=/usr/people/jbw/usr/src/chtex/doc
# where is the software to be installed
BINPATH=/usr/people/jbw/usr/bin
# where is the Ci2Dian3.chi
CDPATH=${HOME}
# where are LaTeX macros
LATEXPATH=/usr/local/lib/tex/macros
# where are TeX tfm files to be installed
TFMPATH=/usr/local/lib/tex/fonts/tfm
     
#what is the list file "docfile.lis" of documentation
DOCFILE_LIST=${SRCPATH}/docfile.lis
     
# where are TeX tfm files from ChTeX.tar
TARTFMPATH=${SRCPATH}/PStfms
     
# you don't need change the following part.
# what are the CCLIB bitmaps?
CCLIB16jt=${CCLIBPATH}/cclib.16
CCLIB16ft=${CCLIBPATH}/cclibf.16
CCLIB24jt=${CCLIBPATH}/cclib.24
CCLIB24ft=/usr/people/ftp/ch-series/cclibf.24
CCLIB48jt=/usr/people/ftp/ch-series/cclib.48
     
CCOPT = -O -DUSG
CFLAGS	= -DCCLIB16jt=\"${CCLIB16jt}\" -DCCLIB24jt=\"${CCLIB24jt}\"\
        -DCCLIB24ft=\"${CCLIB24ft}\" -DTFMarea=\"${TARTFMPATH}\"\
        -DCCLIB16ft=\"${CCLIB16ft}\" \
	-DDOCFILE_LIST=\"${DOCFILE_LIST}\"\
        -DCiDianpath=\"${CDPATH}\" -DCCLIB48jt=\"${CCLIB48jt}\" $(CCOPT)
     
all: chtex chtext chviewer czw cdoc psscribe
     
chtex:chtex.o WStroff.o
	cc ${CFLAGS} -o chtex chtex.o WStroff.o
     
chtext:chtext.o
	cc ${CFLAGS} -o chtext chtext.o
     
chviewer:chviewer.o
	cc ${CFLAGS} -o chviewer chviewer.o
     
czw:	CzW.o
	cc ${CFLAGS} -o czw CzW.o
     
cdoc:	cdoc.c
	cc ${CFLAGS} -o cdoc cdoc.c
     
psscribe:psscribe.o
	cc -o psscribe psscribe.o
     
install: all
	install -s -m 755 chtex ${BINPATH}/chtex
	install -s -m 755 chtext ${BINPATH}/chtext
	install -s -m 755 chviewer ${BINPATH}/chviewer
	install -s -m 755 czw ${BINPATH}/czw
	install -s -m 755 cdoc ${BINPATH}/cdoc
	install -s -m 755 psscribe ${BINPATH}/psscribe
	install -c -m 444 docfile.lis ${DOCFILE_LIST}
	install -c -m 444 doc/*.doc ${DOCPATH}/.
	install -c -m 444 tfm/* ${TFMPATH}/.
	install -c -m 444 PStfms/* ${TFMPATH}/.
	install -c -m 444 Ci2Dian3.chi ${CDPATH}
	install -c -m 444 CCLIB16jt ${CCLIBPATH}
	install -c -m 444 CCLIB24jt ${CCLIBPATH}
	install -c -m 444 CCLIB48jt ${CCLIBPATH}
#	install -c -m 444 CCLIB24ft ${CCLIBPATH}
     
tar:	${SRCPATH}
	tar cfFF ${SRCPATH}/ChTeX.tar \
	src cclib scribe tfm samples doc PStfms man big5gb utilities \
	cctex README makefile Ci2Dian3.chi
	compress  ${SRCPATH}/ChTeX.tar
     
clean:
	rm -f *.o core
     
clobber:  clean
	rm -f chtex chtext chviewer czw cdoc psscribe

