Unit stderr;

{ Output to stderr.

  JCC  3 Jan 92
}

{$V-}
{$N-}

interface
   uses DOS;

   const
      ERRHANDLE = 2;
      STDOUTHANDLE = 1;
   var
      err: text;

   procedure assignerr (var f: text);
   procedure MakeStdErr (var f: text);
      { Set handle for f to stderr, only allow to use if f is stdout}
   procedure MakeStdOut (var f: text);
      { Set handle for f to stdout, only allow to use if f is stderr}


implementation

   var ExitSave: pointer;

{$F+}
function IsDev (var f: TextRec): boolean;
var R: registers;
begin
   with R do begin
      AH := $44;
      AL := 0;
      BX := f.handle;
      MSDOS (R);
      if (Flags and FCarry) <> 0 then
          {Error}
         IsDev := false
      else
         IsDev := ((DX and $80) <> 0);
   end;
end;

function HandleOpen (handle: word): boolean;
   var R: Registers;
   begin
      with R do begin
         AX := $4400;
         BX := handle;
         MSDOS(R);
         HandleOpen := (R.Flags and FCarry) = 0 ;
      end;
   end;

function writedos (handle: word; Count: word; where: pointer): integer;
   var R: Registers;
   begin
      with R do begin
         R.AH := $40;
         R.BX := handle;
         R.CX := Count;
         R.DS := seg(where^);
         R.DX := ofs(where^);
         MSDOS (R);
         if (R.Flags and FCarry) <> 0 then
            writedos := 101;
         writedos := 0;
      end;
   end;

function TextDummy (var F: TextRec): integer;
   begin
      TextDummy := 0;
   end;

function TextOut (var F: TextRec): integer;
   begin
      with F do begin
         if BufPos > 0 then
            TextOut := writedos (Handle, BufPos, BufPtr)
         else {Success by doing nothing}
            TextOut := 0;
         BufPos := 0;
      end;
   end;

function ErrOpen (var F: TextRec): integer;
   begin
      with F do begin
         if Mode = fmOutput then begin
            Handle := ERRHANDLE;
            if HandleOpen (Handle) then begin
               ErrOpen := 0;
               BufSize := SizeOf (Buffer);
               BufPtr := @Buffer;
               InOutFunc := @TextOut;
               if IsDev(f) then
                  FlushFunc := @TextOut
               else
                  FlushFunc := @TextDummy;
               CloseFunc := @TextOut;
            end else begin
               ErrOpen := 5;
            end;
         end else
            ErrOpen := 5;
      end;
   end;

procedure assignErr (var f: text);
   begin
      with TextRec (F) do begin
         Mode := fmclosed;
         BufSize := SizeOf (Buffer);
         BufPtr := @Buffer;
         OpenFunc := @ErrOpen;
      end;
   end;

procedure MakeStdErr (var f: text);
{ Set handle for f to stderr, only allow to use if f is stdout}
   begin
      with TextRec (f) do begin
         if handle = STDOUTHANDLE then
            handle := ERRHANDLE;
      end;
   end;

procedure MakeStdOut (var f: text);
{ Set handle for f to stdout, only allow to use if f is stderr}
   begin
      with TextRec (f) do begin
         if handle = ERRHANDLE then
            handle := STDOUTHANDLE;
      end;
   end;

procedure ErrDone; far;
   begin
      close (Err);
      ExitProc := ExitSave;
   end;


{ ===============INITIALIZATION:======================}
var IOStat: integer;

begin
   AssignErr (Err);
   {$I-}
     Rewrite (Err);
     IOStat := IOResult;
   {$I+}
   if IOStat <> 0 then begin
      writeln ('Cannot open stderr device. Error code = ', IOStat);
      halt (IOStat);
   end;
   ExitSave := ExitProc;
   ExitProc := @ErrDone;
end.

