unit ETTeXSub;
{ Main subroutines for conversion ET to TeX.

FUDGE ON SPLITSEND.  Line breaks not perfect.
  12 Feb 95 JCC  Allow use as filter: make sure messages are sent to
                 LogOutput.
                    InitParams.LogOutput points to file that will receive
                    error and status messages.
                    Err (=stderr from unit stderr) will receive count of
                    lines processed.
                    If ETTOTEX is running as a filter, then it would normally
                    set LogOutput to point to stderr, and the filenames for
                    input and output to blanks.
                    If it is not running as a filter, then it may set
                    LogOutput to point to stdout.
                    The last two behaviors are not necessarily what is
                    wanted, so they are not fixed in this unit.
                 I copy LogOutput to a global variable for this unit, to
                 make it easier to access.
                 See note on constraints on output in the file ettotex.pas.
  20 Jan 93 JCC  Fix up insertion of strings for symbols and substitutions
                 to call SplitSend when needed.  Else lines are output that
                 are too long.
  28 Jul 92 JCC  Report length of longest output line.
   3 Jan 92 JCC  Remove bell in completion message.
   6 Feb 91 JCC  Correct infinite loop in treating argchar
  11 Oct 90 JCC  Further fudge to prevent spurious blank lines at SplitSend.
  19 Sep 90 JCC  Prevent line splits in CSs, comments and CS definitions.
   7 Sep 90 JCC  Correct line breaking
   6 Sep 90 JCC  Start to remove fudges on SPLITSEND
   5 Sep 90 JCC  State --> Params
   7 Aug 90 JCC  Fully delimited fraction.
   2 Aug 90 JCC  fraction support.
  15 Jun 90 JCC  MaxLen is in MyState.
}


{$I etdirect.inc}            {Directives shared by all units}

interface

uses utils, stderr, ETSyms, texetdef;

 procedure ProcessETFile  (var MyParams : Params);


implementation (* ============ IMPLEMENTATION ======================= *)

type
   ChCat = (NoTrans, Subst, symbolCh, special, eol);

var {global variables for transformation.}
   category : array [char] of ChCat;
   SubstStr, SymStr : array [char] of string[16];
   Source, Dest : file;
   LogFile : ^text;  {File to receive error and other messages.  Copied
                      from InitParams.LogOutput.}
   LongestOut, MaxOutLen, BraceLevel, LastEol, NumLine : integer;
   InComment: boolean;
   BraceType: array[0..MaxBrace] of SubSupType;
   CurrentMode: Mode;
   InBuf, OutBuf: TextBuf;
   IPos, OPos, OutLen, NumRead: integer;


{$R-}

(* --------------------- *)

function Max (i,j: integer): integer;
   begin if (i < j) then Max := j else Max := i; end;

procedure Restart (var MyParams: Params);
var
   c: char;
begin
   BraceLevel := 0; (*Outside any {...} pairs.  *)
   BraceType[0] := normal;
   NumLine := 0;
   CurrentMode := InText;
   MaxOutLen := MyParams.MaxLen-length(ContinueStr)-2;
       {Ensures that on straight text I'm within the defined maxlen}

   OPos := 0;
   OutLen := 0;
   LongestOut := 0;   {Longest line actually output}
   LastEol:= 0;

   for c := #0 to #255 do Category[c] := notrans;
   Category [BeginSub] := subst;
   Category [EndSub]   := subst;
   Category [BeginSup] := subst;
   Category [EndSup]   := subst;
   Category [BeginMath]:= subst;
   Category [EndMath]  := subst;
   Category [BeginEq]  := subst;
   Category [EndEq]    := subst;
   Category [BeginArg] := subst;
   Category [EndArg]   := subst;
   Category [BeginFrac]:= subst;
   Category [EndFrac]  := subst;
   Category [Symbol]   := symbolch;
   Category [Bksp]     := subst;
   Category [lf]       := eol;
   Category [cr]       := eol;
   Category [TeXActiveCh] := special;
   Category [CommentChar] := special;
(*   Category [ArgChar]  := special;*)

   for c := #0 to #255 do SubstStr[c] := c;
   SubstStr[BeginSub] := '_{';
   SubstStr[EndSub]   := '}';
   SubstStr[BeginSup] := '^{';
   SubstStr[EndSup]   := '}';
   SubstStr[BeginMath]:= '$';
   SubstStr[EndMath]  := '$';
   SubstStr[BeginEq]  := '$$';
   SubstStr[EndEq]    := '$$';
   SubstStr[BeginArg] := '{';
   SubstStr[EndArg]   := '}';
   SubstStr[BeginFrac]:= '\frac ';
   SubstStr[EndFrac]  := '';
   SubstStr[Bksp]     := '\llap ';

   for c := #0 to #255 do SymStr[c] := c;
   for c := ' ' to #126 do begin
      SymStr[c] := GreekTrans[c];
      if (Length(SymStr[c]) > 1) and
         (SymStr[c][1] = '\') and (SymStr[c][2] in Letters) then
         SymStr[c] := SymStr[c] + ' ';
   end;
end;


procedure ReadMore;
   begin    {ReadMore}
      BlockRead (Source, InBuf, BUFSIZE, NumRead);
      IPos := 1;   {Next Char to read}
   end;     {ReadMore}


procedure FlushOut;
   begin   {FlushOut}
      BlockWrite (Dest, OutBuf, OPos);
      OPos := 0;
      LastEol := 0;
   end;    {FlushOut}

function NextCh: char;
   begin     {NextCh}
      if IPos > NumRead then
         ReadMore;
      if NumRead > 0 then begin
         NextCh := InBuf[IPos];
         inc (IPos);
      end else
         NextCh := EOFCh;
   end;      {NextCh}


function PeekCh: char;
   begin  {PeekCh}
      PeekCh := NextCh;
      if IPos > 1 then dec (IPos);
   end;   {PeekCh}


procedure PutS (s: string);
   begin     {PutS}
      if OPos + length(s) > BUFSIZE then FlushOut;
      Move (s[1], OutBuf[OPos+1], length(s));
      inc (OPos, length(s));
      inc (OutLen, length(s));
   end;      {PutS}


procedure PutCh (c: char);
   begin     {PutCh}
      if OPos + 1 > BUFSIZE then FlushOut;
      inc (OPos);
      OutBuf[OPos] := c;
      if c = cr then begin
         LongestOut := Max (LongestOut, OutLen);
         OutLen := 0;
      end else if c = lf then begin
         LongestOut := Max (LongestOut, OutLen);
         OutLen := 0;
         LastEol := OPos;
      end else
         inc (OutLen);
   end;      {PutCh}


function PrevEWord (var Rec: TextBuf; Posn: integer): integer;
   begin        {PrevEWord}
      while (Posn >= 1) and (Rec[Posn] = ' ') do dec (Posn);
      PrevEWord := Posn;
   end;         {PrevEWord}


function PrevBWord (var Rec: TextBuf; Posn: integer): integer;
   begin        {PrevBWord}
      Posn := PrevEWord (Rec, Posn);
      if Posn > 0 then begin
         while (Posn > 0) and (Rec[Posn] <> ' ') do dec (Posn);
         inc (Posn);
      end;
      PrevBWord := Posn;
   end;         {PrevBWord}


procedure SplitSend;
   var i: integer;
   begin     {SplitSend}
      (* TEMPORARY BREAK WITH COMMENT.  *)
      (* FOR MOMENT FUDGE BLANK LINE PROBLEM.  ALGORITHM
         FAILS IF SPACE AT END OF LINE.  PROBLEM: IF SPLIT ONE
         CHARACTER BEFORE EOL THEN GET UNWANTED BLANK LINE, WHICH
         IS \par
      *)
      if category[PeekCh] <> eol then begin
         PutS (ContinueStr+cr+lf);
         LongestOut := Max (LongestOut, OutLen);
         OutLen := 0;
      end;
(*      FlushOut;
*)
(*      i := PrevEWord (ORec, OPos);
      if i < MaxOutLen then begin
         ORec[0] := chr(i);
         writeln (Dest, ORec);
         OPos := 0;
         ORec := '';
      end else begin
         repeat
            i := PrevBWord (ORec, i);
            dec (i);
            if i > 0 then i := PrevEWord (ORec, i);
         until i < MaxOutLen;
         if i <= 1 then begin
            writeln (Dest, Copy (ORec, 1, MaxOutLen));
            writeln (Dest, ' ********** BAD BREAK *********');
            Delete (ORec, 1, MaxOutLen);
         end else begin
            writeln (Dest, Copy (ORec, 1, i));
            Delete (ORec, 1, i);
         end;
         RLB (ORec);
         OPos := ord (ORec[0]);
      end;
*)
   end;       {SplitSend}


procedure Send;
   begin  {Send}
    FlushOut;
(*      ORec[0] := chr(OPos);
      RTB (ORec);
      OPos := length(ORec);
      while length (ORec) > MaxOutLen do
         SplitSend (ORec, OPos);
      writeln (Dest, ORec);
      OPos := 0;
      ORec := '';
*)
   end;  {Send}


procedure DoProcessFile;
      var
         c, c1: char;
         DoSubst: boolean;
      procedure ShowError (s: string);
         begin writeln (LogFile^, s, ', in line ', NumLine);
         end;
   begin    {DoProcessFile}
      while not eof(Source) do begin
         ReadMore;
         while IPos <= NumRead do begin
            { Assume IPos points to next character to process }
            c := InBuf[IPos];
            inc (IPos);
      {Split if need be, but prevent break on endbrace-beginbrace}
            if (Outlen > MaxOutLen) and (c <> beginarg) then begin
               SplitSend;
            end;
            if OPos >= BUFSIZE - 100 then FlushOut;
            case category[c] of
               NoTrans: begin
                     inc(OPos);
                     OutBuf[OPos] := c;
                     inc (OutLen);
                  end;
               subst: begin
                  DoSubst := true;
                  { Check for math that gives bm+em --> $$ etc: }
                  c1 := PeekCh;
                  if ((c=beginmath) and (c1=endmath))
                     or ((c=endmath) and (c=beginmath)) then begin
                        DoSubst := false;
                        Inc (Ipos);
                  end;
                  { Check for inconsistent modes: }
                  case c of
                     beginmath: if (CurrentMode <> InText) then begin
                              ShowError ('Begin math mode while not in text');
                              DoSubst := false;
                           end else
                              CurrentMode := InMath;
                     endmath: if (CurrentMode <> InMath) then begin
                              ShowError ('End math mode while not in math');
                              DoSubst := false;
                           end else
                              CurrentMode := InText;
                     begineq: if (CurrentMode <> InText) then begin
                              ShowError ('Begin eq mode while not in text');
                              DoSubst := false;
                           end else
                              CurrentMode := InEq;
                     endeq: if (CurrentMode <> InEq) then begin
                              ShowError ('End eq mode while not in eq');
                              DoSubst := false;
                           end else
                              CurrentMode := InText;
                  end;
                  if DoSubst then begin
                     if (Outlen + length(substStr[c])+1> MaxOutLen) then begin
                        SplitSend;
                     end;
                     PutS (substStr[c]);
                  end;
               end;
               symbolch: begin
                  c := NextCh;
                  if (c < ' ') or (c > #126) then c := ' ';
                  if (Outlen + length(SymStr[c])+1> MaxOutLen) then begin
                     SplitSend;
                  end;
                  PutS (SymStr[c]);
               end;
               eol: begin
                  if c = lf then begin
                     inc (NumLine);
                     {Record of lines goes to stderr always.}
                     if (NumLine mod 50) = 0 then write (Err, NumLine, cr);
                  end;
                  PutCh (c);
                  LongestOut := Max (LongestOut, OutLen);
                  OutLen := 0;
               end;
               special: begin
                  PutCh (c);
                  case c of   {Should use std subroutines here.}
                     TeXActiveCh: begin
                        c1 := NextCh;
                        PutCh (c1);
                        if c1 in letters then begin
                          repeat
                             c1 := PeekCh;
                             if c1 in letters then begin
                                inc (ipos);
                                PutCh (c1);
                             end;
                          until not (c1 in letters);
                        end;
                     end;
                     CommentChar: begin
                        repeat
                          c1 := NextCh;
                          PutCh (c1)
                        until (category [c1]=eol) or (c1 = EOFCh);
                     end;
                  end;
               end;
               else begin
                 writeln (LogFile^, 'Bad Ch ', ord(c));
                 PutCh (c);
               end;
            end; {case}
         end; {while in InBuf}
      end; {while}
      FlushOut;
   end;    {DoProcessFile}



procedure ProcessETFile  (var MyParams : Params);
   var
      Line : LongString;

   begin    {ProcessETFile}
      with MyParams do begin
         {Put this in a variable of file scope.
          Wierd happening: LogFile := LogOutput gives a type mismatch!
         }
         LogFile := @(LogOutput^);
         {Note: if SourceName = '',then TURBO PASCAL will use stdin.}
         Assign (Source, SourceName);
         {$I-}
         Reset (Source, 1);
         {$I+}
         if IOResult <> 0 then begin
            writeln (LogFile^, 'Cannot open input file ''', SourceName, '''.');
            exit;
         end;
         {Note: if DestName = '',then TURBO PASCAL will use stdout.}
         Assign (Dest, DestName);
         {$I-}
         Rewrite (Dest, 1);
         {$I+}
         if IOResult <> 0 then begin
            close (source);
            writeln (LogFile^, 'Cannot open output device ''', DestName, '''.');
            exit;
         end;
      end; {with}

      ReStart (MyParams);
      DoProcessFile;
      close (Dest);
      close (Source);
      writeln (Err);
      writeln (LogFile^, 'FINISHED: ', NumLine, ' lines processed.');
      writeln (LogFile^, '   Longest output line was ', LongestOut);
   end;    {ProcessETFile}

(* ==================== INITIALIZATION ============================  *)
begin
end.


