#include <sys/rsxw32.h>

#ifdef __OPTIMIZE__
extern __inline__ unsigned short GetDS(void)
{
    register unsigned short v;
    __asm__("movw %%ds, %0 \n\t"
	    : "=r" ((unsigned short) v) );
    return v;
}
extern __inline__ unsigned short GetES(void)
{
    register unsigned short v;
    __asm__("movw %%es, %0 \n\t"
	    : "=r" ((unsigned short) v) );
    return v;
}
#endif

struct REGPACK {
    unsigned long eax;
    unsigned long ebx;
    unsigned long ecx;
    unsigned long edx;
    unsigned long esi;
    unsigned long edi;
    unsigned long eflags;
};

struct SEGPACK {
    unsigned short ds;
    unsigned short es;
};

#ifndef _FIND_T_DEFINED
#define _FIND_T_DEFINED
struct find_t {
	char		reserved[21];
	unsigned char	attrib;
	unsigned short	wr_time;
	unsigned short	wr_date;
	unsigned short	size_lo;
	unsigned short	size_hi;
	char		name[13];
	};
#endif

#ifndef _DATETIME_T_DEFINED
#define _DATETIME_T_DEFINED
struct dos_date {
    unsigned short ddate_year;	    /* 1980 - 2099 */
    unsigned char  ddate_month;     /* 1 - 12 */
    unsigned char  ddate_day;	    /* 1 - 31 */
    unsigned char  ddate_dayofweek; /* 0 = sonday */
};

struct dos_time {
    unsigned char dtime_hour;	   /* 0 - 23 */
    unsigned char dtime_minutes;   /* 0 - 59 */
    unsigned char dtime_seconds;   /* 0 - 59 */
    unsigned char dtime_hsec;	   /* 0 - 99 */
};

struct file_time {
    unsigned short ft_date;
    unsigned short ft_time;
};
#endif

#if !defined (DOS_O_RDONLY)
#define DOS_O_RDONLY	     0x0000
#define DOS_O_NOINHERIT      0x0080
#define DOS_O_DENYWR	     0x0020
#endif

typedef int (*READFUNC) (int, void *, int);
typedef int (*WRITEFUNC) (int, void *, int);

extern READFUNC _console_read;
extern WRITEFUNC _console_write;

int	_intr (int no, struct REGPACK *);
int	_intxr (int no, struct REGPACK *, struct SEGPACK *);
void	_sys_doserror2errno(unsigned short error_dos);

int	dos_setdrive(unsigned char drive);
unsigned char dos_getdrive(void);
void	dos_getdate(struct dos_date * dd);
int	dos_setdate(struct dos_date * dd);
void	dos_gettime(struct dos_time * dt);
int	dos_settime(struct dos_time * dt);
int	dos_mkdir(const char *name);
int	dos_rmdir(const char *name);
int	dos_chdir(const char *name);
int	dos_remove(const char *name);
int	dos_getfattr(const char *name, int * attr);
int	dos_access(const char *name, int mode);
int	dos_setfattr(const char *name, int attr);
int	dos_getcwd(unsigned char drive, char *name);
int	dos_findfirst(const char *name, int attr);
int	dos_findnext(void);
void	dos_setdta(void *buf);
int	dos_rename(const char *name1, const char *name2);
int	dos_creat(const char *name, int attr);
int	dos_open(const char *name, int modes);
int	dos_close(int handle);
int	dos_read(int handle, void *buf, unsigned bytes);
int	dos_write(int handle, const void *buf, unsigned bytes);
long	dos_lseek(int handle, long offset, int orgin);
int	dos_dup(int handle);
int	dos_dup2(int handle, int newhandle);
int	dos_getftime(int handle, unsigned short * date, unsigned short * time);
int	dos_setftime(int handle, unsigned short date, unsigned short time);
int	dos_creatnew(const char *name, int attr);
int	dos_ioctl(int handle, int code);
int	dos_ioctl_getattr(int handle);
int	dos_isatty(int handle);
int	dos_ioctl_setattr(int handle, int mode);
int	dos_ioctl_select_in(int handle);
int	dos_ioctl_remotedrive(unsigned char drive);
